/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSubnetsRequestMarshaller
implements Marshaller<Request<DescribeSubnetsRequest>, DescribeSubnetsRequest> {
    @Override
    public Request<DescribeSubnetsRequest> marshall(DescribeSubnetsRequest describeSubnetsRequest) {
        SdkInternalList describeSubnetsRequestFiltersList;
        if (describeSubnetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSubnetsRequest> request = new DefaultRequest<DescribeSubnetsRequest>(describeSubnetsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSubnets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSubnetsRequestSubnetIdsList = (SdkInternalList)describeSubnetsRequest.getSubnetIds();
        if (!describeSubnetsRequestSubnetIdsList.isEmpty() || !describeSubnetsRequestSubnetIdsList.isAutoConstruct()) {
            int subnetIdsListIndex = 1;
            for (String describeSubnetsRequestSubnetIdsListValue : describeSubnetsRequestSubnetIdsList) {
                if (describeSubnetsRequestSubnetIdsListValue != null) {
                    request.addParameter("SubnetId." + subnetIdsListIndex, StringUtils.fromString(describeSubnetsRequestSubnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!(describeSubnetsRequestFiltersList = (SdkInternalList)describeSubnetsRequest.getFilters()).isEmpty() || !describeSubnetsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeSubnetsRequestFiltersListValue : describeSubnetsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeSubnetsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeSubnetsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeSubnetsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

