/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.UpdateAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class UpdateAliasRequestMarshaller
implements Marshaller<Request<UpdateAliasRequest>, UpdateAliasRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateAliasRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateAliasRequest> marshall(UpdateAliasRequest updateAliasRequest) {
        if (updateAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAliasRequest> request = new DefaultRequest<UpdateAliasRequest>(updateAliasRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/aliases/{Name}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", updateAliasRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateAliasRequest.getFunctionName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{Name}", updateAliasRequest.getName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateAliasRequest.getName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateAliasRequest.getFunctionVersion() != null) {
                jsonGenerator.writeFieldName("FunctionVersion").writeValue(updateAliasRequest.getFunctionVersion());
            }
            if (updateAliasRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateAliasRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

