/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListStepsRequestMarshaller
implements Marshaller<Request<ListStepsRequest>, ListStepsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListStepsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListStepsRequest> marshall(ListStepsRequest listStepsRequest) {
        if (listStepsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStepsRequest> request = new DefaultRequest<ListStepsRequest>(listStepsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListSteps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList stepIdsList;
            SdkInternalList stepStatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listStepsRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(listStepsRequest.getClusterId());
            }
            if (!(stepStatesList = (SdkInternalList)listStepsRequest.getStepStates()).isEmpty() || !stepStatesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("StepStates");
                jsonGenerator.writeStartArray();
                for (String stepStatesListValue : stepStatesList) {
                    if (stepStatesListValue == null) continue;
                    jsonGenerator.writeValue(stepStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(stepIdsList = (SdkInternalList)listStepsRequest.getStepIds()).isEmpty() || !stepIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("StepIds");
                jsonGenerator.writeStartArray();
                for (String stepIdsListValue : stepIdsList) {
                    if (stepIdsListValue == null) continue;
                    jsonGenerator.writeValue(stepIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listStepsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listStepsRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

