/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.LaunchConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class LaunchConfigurationStaxUnmarshaller
implements Unmarshaller<LaunchConfiguration, StaxUnmarshallerContext> {
    private static LaunchConfigurationStaxUnmarshaller instance;

    @Override
    public LaunchConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchConfiguration launchConfiguration = new LaunchConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return launchConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Name", targetDepth)) continue;
                launchConfiguration.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return launchConfiguration;
    }

    public static LaunchConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

