/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueUpdateJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ExpectedAttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class UpdateItemRequestMarshaller
implements Marshaller<Request<UpdateItemRequest>, UpdateItemRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateItemRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateItemRequest> marshall(UpdateItemRequest updateItemRequest) {
        if (updateItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateItemRequest> request = new DefaultRequest<UpdateItemRequest>(updateItemRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.UpdateItem");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> expressionAttributeValuesMap;
            Map<String, String> expressionAttributeNamesMap;
            Map<String, ExpectedAttributeValue> expectedMap;
            Map<String, AttributeValueUpdate> attributeUpdatesMap;
            Map<String, AttributeValue> keyMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateItemRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(updateItemRequest.getTableName());
            }
            if ((keyMap = updateItemRequest.getKey()) != null) {
                jsonGenerator.writeFieldName("Key");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> keyMapValue : keyMap.entrySet()) {
                    if (keyMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(keyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(keyMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((attributeUpdatesMap = updateItemRequest.getAttributeUpdates()) != null) {
                jsonGenerator.writeFieldName("AttributeUpdates");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValueUpdate> attributeUpdatesMapValue : attributeUpdatesMap.entrySet()) {
                    if (attributeUpdatesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributeUpdatesMapValue.getKey());
                    AttributeValueUpdateJsonMarshaller.getInstance().marshall(attributeUpdatesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((expectedMap = updateItemRequest.getExpected()) != null) {
                jsonGenerator.writeFieldName("Expected");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, ExpectedAttributeValue> expectedMapValue : expectedMap.entrySet()) {
                    if (expectedMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expectedMapValue.getKey());
                    ExpectedAttributeValueJsonMarshaller.getInstance().marshall(expectedMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (updateItemRequest.getConditionalOperator() != null) {
                jsonGenerator.writeFieldName("ConditionalOperator").writeValue(updateItemRequest.getConditionalOperator());
            }
            if (updateItemRequest.getReturnValues() != null) {
                jsonGenerator.writeFieldName("ReturnValues").writeValue(updateItemRequest.getReturnValues());
            }
            if (updateItemRequest.getReturnConsumedCapacity() != null) {
                jsonGenerator.writeFieldName("ReturnConsumedCapacity").writeValue(updateItemRequest.getReturnConsumedCapacity());
            }
            if (updateItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonGenerator.writeFieldName("ReturnItemCollectionMetrics").writeValue(updateItemRequest.getReturnItemCollectionMetrics());
            }
            if (updateItemRequest.getUpdateExpression() != null) {
                jsonGenerator.writeFieldName("UpdateExpression").writeValue(updateItemRequest.getUpdateExpression());
            }
            if (updateItemRequest.getConditionExpression() != null) {
                jsonGenerator.writeFieldName("ConditionExpression").writeValue(updateItemRequest.getConditionExpression());
            }
            if ((expressionAttributeNamesMap = updateItemRequest.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> expressionAttributeNamesMapValue : expressionAttributeNamesMap.entrySet()) {
                    if (expressionAttributeNamesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expressionAttributeNamesMapValue.getKey());
                    jsonGenerator.writeValue(expressionAttributeNamesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((expressionAttributeValuesMap = updateItemRequest.getExpressionAttributeValues()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> expressionAttributeValuesMapValue : expressionAttributeValuesMap.entrySet()) {
                    if (expressionAttributeValuesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(expressionAttributeValuesMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

