/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.directory.AWSDirectoryService;
import com.amazonaws.services.directory.model.AuthenticationFailedException;
import com.amazonaws.services.directory.model.ClientException;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.ConnectDirectoryResult;
import com.amazonaws.services.directory.model.CreateAliasRequest;
import com.amazonaws.services.directory.model.CreateAliasResult;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.CreateComputerResult;
import com.amazonaws.services.directory.model.CreateConditionalForwarderRequest;
import com.amazonaws.services.directory.model.CreateConditionalForwarderResult;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.CreateDirectoryResult;
import com.amazonaws.services.directory.model.CreateMicrosoftADRequest;
import com.amazonaws.services.directory.model.CreateMicrosoftADResult;
import com.amazonaws.services.directory.model.CreateSnapshotRequest;
import com.amazonaws.services.directory.model.CreateSnapshotResult;
import com.amazonaws.services.directory.model.CreateTrustRequest;
import com.amazonaws.services.directory.model.CreateTrustResult;
import com.amazonaws.services.directory.model.DeleteConditionalForwarderRequest;
import com.amazonaws.services.directory.model.DeleteConditionalForwarderResult;
import com.amazonaws.services.directory.model.DeleteDirectoryRequest;
import com.amazonaws.services.directory.model.DeleteDirectoryResult;
import com.amazonaws.services.directory.model.DeleteSnapshotRequest;
import com.amazonaws.services.directory.model.DeleteSnapshotResult;
import com.amazonaws.services.directory.model.DeleteTrustRequest;
import com.amazonaws.services.directory.model.DeleteTrustResult;
import com.amazonaws.services.directory.model.DeregisterEventTopicRequest;
import com.amazonaws.services.directory.model.DeregisterEventTopicResult;
import com.amazonaws.services.directory.model.DescribeConditionalForwardersRequest;
import com.amazonaws.services.directory.model.DescribeConditionalForwardersResult;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.services.directory.model.DescribeDirectoriesResult;
import com.amazonaws.services.directory.model.DescribeEventTopicsRequest;
import com.amazonaws.services.directory.model.DescribeEventTopicsResult;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.services.directory.model.DescribeSnapshotsResult;
import com.amazonaws.services.directory.model.DescribeTrustsRequest;
import com.amazonaws.services.directory.model.DescribeTrustsResult;
import com.amazonaws.services.directory.model.DirectoryLimitExceededException;
import com.amazonaws.services.directory.model.DirectoryUnavailableException;
import com.amazonaws.services.directory.model.DisableRadiusRequest;
import com.amazonaws.services.directory.model.DisableRadiusResult;
import com.amazonaws.services.directory.model.DisableSsoRequest;
import com.amazonaws.services.directory.model.DisableSsoResult;
import com.amazonaws.services.directory.model.EnableRadiusRequest;
import com.amazonaws.services.directory.model.EnableRadiusResult;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.services.directory.model.EnableSsoResult;
import com.amazonaws.services.directory.model.EntityAlreadyExistsException;
import com.amazonaws.services.directory.model.EntityDoesNotExistException;
import com.amazonaws.services.directory.model.GetDirectoryLimitsRequest;
import com.amazonaws.services.directory.model.GetDirectoryLimitsResult;
import com.amazonaws.services.directory.model.GetSnapshotLimitsRequest;
import com.amazonaws.services.directory.model.GetSnapshotLimitsResult;
import com.amazonaws.services.directory.model.InsufficientPermissionsException;
import com.amazonaws.services.directory.model.InvalidNextTokenException;
import com.amazonaws.services.directory.model.InvalidParameterException;
import com.amazonaws.services.directory.model.RegisterEventTopicRequest;
import com.amazonaws.services.directory.model.RegisterEventTopicResult;
import com.amazonaws.services.directory.model.RestoreFromSnapshotRequest;
import com.amazonaws.services.directory.model.RestoreFromSnapshotResult;
import com.amazonaws.services.directory.model.ServiceException;
import com.amazonaws.services.directory.model.SnapshotLimitExceededException;
import com.amazonaws.services.directory.model.UnsupportedOperationException;
import com.amazonaws.services.directory.model.UpdateConditionalForwarderRequest;
import com.amazonaws.services.directory.model.UpdateConditionalForwarderResult;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.services.directory.model.UpdateRadiusResult;
import com.amazonaws.services.directory.model.VerifyTrustRequest;
import com.amazonaws.services.directory.model.VerifyTrustResult;
import com.amazonaws.services.directory.model.transform.ConnectDirectoryRequestMarshaller;
import com.amazonaws.services.directory.model.transform.ConnectDirectoryResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateAliasRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateAliasResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateComputerRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateComputerResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateConditionalForwarderRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateConditionalForwarderResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateDirectoryRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateDirectoryResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateMicrosoftADRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateMicrosoftADResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateSnapshotRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateTrustRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateTrustResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeleteConditionalForwarderRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeleteConditionalForwarderResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeleteDirectoryRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeleteDirectoryResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeleteSnapshotRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeleteSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeleteTrustRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeleteTrustResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeregisterEventTopicRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeregisterEventTopicResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeConditionalForwardersRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeConditionalForwardersResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeDirectoriesRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeDirectoriesResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeEventTopicsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeEventTopicsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeSnapshotsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeSnapshotsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeTrustsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeTrustsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DisableRadiusRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DisableRadiusResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DisableSsoRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DisableSsoResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.EnableRadiusRequestMarshaller;
import com.amazonaws.services.directory.model.transform.EnableRadiusResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.EnableSsoRequestMarshaller;
import com.amazonaws.services.directory.model.transform.EnableSsoResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.GetDirectoryLimitsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.GetDirectoryLimitsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.GetSnapshotLimitsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.GetSnapshotLimitsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.RegisterEventTopicRequestMarshaller;
import com.amazonaws.services.directory.model.transform.RegisterEventTopicResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.RestoreFromSnapshotRequestMarshaller;
import com.amazonaws.services.directory.model.transform.RestoreFromSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.UpdateConditionalForwarderRequestMarshaller;
import com.amazonaws.services.directory.model.transform.UpdateConditionalForwarderResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.UpdateRadiusRequestMarshaller;
import com.amazonaws.services.directory.model.transform.UpdateRadiusResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.VerifyTrustRequestMarshaller;
import com.amazonaws.services.directory.model.transform.VerifyTrustResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSDirectoryServiceClient
extends AmazonWebServiceClient
implements AWSDirectoryService {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSDirectoryService.class);
    private static final String DEFAULT_SIGNING_NAME = "ds";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceException").withModeledClass(ServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityAlreadyExistsException").withModeledClass(EntityAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SnapshotLimitExceededException").withModeledClass(SnapshotLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedOperationException").withModeledClass(UnsupportedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EntityDoesNotExistException").withModeledClass(EntityDoesNotExistException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InsufficientPermissionsException").withModeledClass(InsufficientPermissionsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientException").withModeledClass(ClientException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DirectoryLimitExceededException").withModeledClass(DirectoryLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AuthenticationFailedException").withModeledClass(AuthenticationFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DirectoryUnavailableException").withModeledClass(DirectoryUnavailableException.class)));

    public AWSDirectoryServiceClient() {
        this(new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSDirectoryServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSDirectoryServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSDirectoryServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSDirectoryServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSDirectoryServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSDirectoryServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://ds.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/directory/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/directory/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectDirectoryResult connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(connectDirectoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConnectDirectoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConnectDirectoryRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(connectDirectoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ConnectDirectoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConnectDirectoryResult connectDirectoryResult = (ConnectDirectoryResult)response.getAwsResponse();
            return connectDirectoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResult createAlias(CreateAliasRequest createAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAliasRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateAliasResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAliasResult createAliasResult = (CreateAliasResult)response.getAwsResponse();
            return createAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComputerResult createComputer(CreateComputerRequest createComputerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createComputerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateComputerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateComputerRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createComputerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateComputerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateComputerResult createComputerResult = (CreateComputerResult)response.getAwsResponse();
            return createComputerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConditionalForwarderResult createConditionalForwarder(CreateConditionalForwarderRequest createConditionalForwarderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConditionalForwarderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConditionalForwarderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConditionalForwarderRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createConditionalForwarderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateConditionalForwarderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConditionalForwarderResult createConditionalForwarderResult = (CreateConditionalForwarderResult)response.getAwsResponse();
            return createConditionalForwarderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectoryResult createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDirectoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDirectoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDirectoryRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createDirectoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateDirectoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDirectoryResult createDirectoryResult = (CreateDirectoryResult)response.getAwsResponse();
            return createDirectoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMicrosoftADResult createMicrosoftAD(CreateMicrosoftADRequest createMicrosoftADRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMicrosoftADRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMicrosoftADRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMicrosoftADRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createMicrosoftADRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateMicrosoftADResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMicrosoftADResult createMicrosoftADResult = (CreateMicrosoftADResult)response.getAwsResponse();
            return createMicrosoftADResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSnapshotRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateSnapshotResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateSnapshotResult createSnapshotResult = (CreateSnapshotResult)response.getAwsResponse();
            return createSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrustResult createTrust(CreateTrustRequest createTrustRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTrustRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTrustRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTrustRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createTrustRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateTrustResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTrustResult createTrustResult = (CreateTrustResult)response.getAwsResponse();
            return createTrustResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConditionalForwarderResult deleteConditionalForwarder(DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConditionalForwarderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConditionalForwarderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConditionalForwarderRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteConditionalForwarderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteConditionalForwarderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConditionalForwarderResult deleteConditionalForwarderResult = (DeleteConditionalForwarderResult)response.getAwsResponse();
            return deleteConditionalForwarderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectoryResult deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDirectoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDirectoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDirectoryRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteDirectoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDirectoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDirectoryResult deleteDirectoryResult = (DeleteDirectoryResult)response.getAwsResponse();
            return deleteDirectoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResult deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSnapshotRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteSnapshotResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSnapshotResult deleteSnapshotResult = (DeleteSnapshotResult)response.getAwsResponse();
            return deleteSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrustResult deleteTrust(DeleteTrustRequest deleteTrustRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTrustRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTrustRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTrustRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteTrustRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTrustResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTrustResult deleteTrustResult = (DeleteTrustResult)response.getAwsResponse();
            return deleteTrustResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterEventTopicResult deregisterEventTopic(DeregisterEventTopicRequest deregisterEventTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterEventTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterEventTopicRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterEventTopicRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deregisterEventTopicRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeregisterEventTopicResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterEventTopicResult deregisterEventTopicResult = (DeregisterEventTopicResult)response.getAwsResponse();
            return deregisterEventTopicResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConditionalForwardersResult describeConditionalForwarders(DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConditionalForwardersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConditionalForwardersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConditionalForwardersRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeConditionalForwardersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeConditionalForwardersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConditionalForwardersResult describeConditionalForwardersResult = (DescribeConditionalForwardersResult)response.getAwsResponse();
            return describeConditionalForwardersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectoriesResult describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDirectoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDirectoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDirectoriesRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeDirectoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDirectoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDirectoriesResult describeDirectoriesResult = (DescribeDirectoriesResult)response.getAwsResponse();
            return describeDirectoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDirectoriesResult describeDirectories() {
        return this.describeDirectories(new DescribeDirectoriesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventTopicsResult describeEventTopics(DescribeEventTopicsRequest describeEventTopicsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventTopicsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventTopicsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventTopicsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeEventTopicsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeEventTopicsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventTopicsResult describeEventTopicsResult = (DescribeEventTopicsResult)response.getAwsResponse();
            return describeEventTopicsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResult describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSnapshotsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSnapshotsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSnapshotsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeSnapshotsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeSnapshotsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSnapshotsResult describeSnapshotsResult = (DescribeSnapshotsResult)response.getAwsResponse();
            return describeSnapshotsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSnapshotsResult describeSnapshots() {
        return this.describeSnapshots(new DescribeSnapshotsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustsResult describeTrusts(DescribeTrustsRequest describeTrustsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrustsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrustsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrustsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeTrustsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTrustsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrustsResult describeTrustsResult = (DescribeTrustsResult)response.getAwsResponse();
            return describeTrustsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableRadiusResult disableRadius(DisableRadiusRequest disableRadiusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableRadiusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableRadiusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableRadiusRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(disableRadiusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisableRadiusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableRadiusResult disableRadiusResult = (DisableRadiusResult)response.getAwsResponse();
            return disableRadiusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableSsoResult disableSso(DisableSsoRequest disableSsoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableSsoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableSsoRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableSsoRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(disableSsoRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisableSsoResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableSsoResult disableSsoResult = (DisableSsoResult)response.getAwsResponse();
            return disableSsoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableRadiusResult enableRadius(EnableRadiusRequest enableRadiusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableRadiusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableRadiusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableRadiusRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(enableRadiusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new EnableRadiusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableRadiusResult enableRadiusResult = (EnableRadiusResult)response.getAwsResponse();
            return enableRadiusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableSsoResult enableSso(EnableSsoRequest enableSsoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableSsoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableSsoRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableSsoRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(enableSsoRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new EnableSsoResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableSsoResult enableSsoResult = (EnableSsoResult)response.getAwsResponse();
            return enableSsoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDirectoryLimitsResult getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDirectoryLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDirectoryLimitsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDirectoryLimitsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getDirectoryLimitsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDirectoryLimitsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDirectoryLimitsResult getDirectoryLimitsResult = (GetDirectoryLimitsResult)response.getAwsResponse();
            return getDirectoryLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDirectoryLimitsResult getDirectoryLimits() {
        return this.getDirectoryLimits(new GetDirectoryLimitsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotLimitsResult getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSnapshotLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSnapshotLimitsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSnapshotLimitsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getSnapshotLimitsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetSnapshotLimitsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSnapshotLimitsResult getSnapshotLimitsResult = (GetSnapshotLimitsResult)response.getAwsResponse();
            return getSnapshotLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterEventTopicResult registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerEventTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterEventTopicRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterEventTopicRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(registerEventTopicRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RegisterEventTopicResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterEventTopicResult registerEventTopicResult = (RegisterEventTopicResult)response.getAwsResponse();
            return registerEventTopicResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreFromSnapshotResult restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreFromSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreFromSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreFromSnapshotRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(restoreFromSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RestoreFromSnapshotResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RestoreFromSnapshotResult restoreFromSnapshotResult = (RestoreFromSnapshotResult)response.getAwsResponse();
            return restoreFromSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConditionalForwarderResult updateConditionalForwarder(UpdateConditionalForwarderRequest updateConditionalForwarderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConditionalForwarderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateConditionalForwarderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateConditionalForwarderRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateConditionalForwarderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateConditionalForwarderResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateConditionalForwarderResult updateConditionalForwarderResult = (UpdateConditionalForwarderResult)response.getAwsResponse();
            return updateConditionalForwarderResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRadiusResult updateRadius(UpdateRadiusRequest updateRadiusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRadiusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRadiusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRadiusRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateRadiusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRadiusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRadiusResult updateRadiusResult = (UpdateRadiusResult)response.getAwsResponse();
            return updateRadiusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyTrustResult verifyTrust(VerifyTrustRequest verifyTrustRequest) {
        ExecutionContext executionContext = this.createExecutionContext(verifyTrustRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<VerifyTrustRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new VerifyTrustRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(verifyTrustRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new VerifyTrustResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            VerifyTrustResult verifyTrustResult = (VerifyTrustResult)response.getAwsResponse();
            return verifyTrustResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

