/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.TestInvokeMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class TestInvokeMethodRequestMarshaller
implements Marshaller<Request<TestInvokeMethodRequest>, TestInvokeMethodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TestInvokeMethodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<TestInvokeMethodRequest> marshall(TestInvokeMethodRequest testInvokeMethodRequest) {
        if (testInvokeMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestInvokeMethodRequest> request = new DefaultRequest<TestInvokeMethodRequest>(testInvokeMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", testInvokeMethodRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(testInvokeMethodRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", testInvokeMethodRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(testInvokeMethodRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", testInvokeMethodRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(testInvokeMethodRequest.getHttpMethod()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> stageVariablesMap;
            Map<String, String> headersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (testInvokeMethodRequest.getPathWithQueryString() != null) {
                jsonGenerator.writeFieldName("pathWithQueryString").writeValue(testInvokeMethodRequest.getPathWithQueryString());
            }
            if (testInvokeMethodRequest.getBody() != null) {
                jsonGenerator.writeFieldName("body").writeValue(testInvokeMethodRequest.getBody());
            }
            if ((headersMap = testInvokeMethodRequest.getHeaders()) != null) {
                jsonGenerator.writeFieldName("headers");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> headersMapValue : headersMap.entrySet()) {
                    if (headersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(headersMapValue.getKey());
                    jsonGenerator.writeValue(headersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (testInvokeMethodRequest.getClientCertificateId() != null) {
                jsonGenerator.writeFieldName("clientCertificateId").writeValue(testInvokeMethodRequest.getClientCertificateId());
            }
            if ((stageVariablesMap = testInvokeMethodRequest.getStageVariables()) != null) {
                jsonGenerator.writeFieldName("stageVariables");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> stageVariablesMapValue : stageVariablesMap.entrySet()) {
                    if (stageVariablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(stageVariablesMapValue.getKey());
                    jsonGenerator.writeValue(stageVariablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

