/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.workspaces.model.RebuildRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.services.workspaces.model.transform.RebuildRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RebuildWorkspacesRequestMarshaller
implements Marshaller<Request<RebuildWorkspacesRequest>, RebuildWorkspacesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RebuildWorkspacesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RebuildWorkspacesRequest> marshall(RebuildWorkspacesRequest rebuildWorkspacesRequest) {
        if (rebuildWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RebuildWorkspacesRequest> request = new DefaultRequest<RebuildWorkspacesRequest>(rebuildWorkspacesRequest, "AmazonWorkspaces");
        request.addHeader("X-Amz-Target", "WorkspacesService.RebuildWorkspaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList rebuildWorkspaceRequestsList = (SdkInternalList)rebuildWorkspacesRequest.getRebuildWorkspaceRequests();
            if (!rebuildWorkspaceRequestsList.isEmpty() || !rebuildWorkspaceRequestsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RebuildWorkspaceRequests");
                jsonGenerator.writeStartArray();
                for (RebuildRequest rebuildWorkspaceRequestsListValue : rebuildWorkspaceRequestsList) {
                    if (rebuildWorkspaceRequestsListValue == null) continue;
                    RebuildRequestJsonMarshaller.getInstance().marshall(rebuildWorkspaceRequestsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

