/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeDeliveryStreamRequestMarshaller
implements Marshaller<Request<DescribeDeliveryStreamRequest>, DescribeDeliveryStreamRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeDeliveryStreamRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeDeliveryStreamRequest> marshall(DescribeDeliveryStreamRequest describeDeliveryStreamRequest) {
        if (describeDeliveryStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDeliveryStreamRequest> request = new DefaultRequest<DescribeDeliveryStreamRequest>(describeDeliveryStreamRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.DescribeDeliveryStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeDeliveryStreamRequest.getDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamName").writeValue(describeDeliveryStreamRequest.getDeliveryStreamName());
            }
            if (describeDeliveryStreamRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeDeliveryStreamRequest.getLimit());
            }
            if (describeDeliveryStreamRequest.getExclusiveStartDestinationId() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartDestinationId").writeValue(describeDeliveryStreamRequest.getExclusiveStartDestinationId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

