/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class IncreaseStreamRetentionPeriodRequestMarshaller
implements Marshaller<Request<IncreaseStreamRetentionPeriodRequest>, IncreaseStreamRetentionPeriodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public IncreaseStreamRetentionPeriodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<IncreaseStreamRetentionPeriodRequest> marshall(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        if (increaseStreamRetentionPeriodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<IncreaseStreamRetentionPeriodRequest> request = new DefaultRequest<IncreaseStreamRetentionPeriodRequest>(increaseStreamRetentionPeriodRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.IncreaseStreamRetentionPeriod");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (increaseStreamRetentionPeriodRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(increaseStreamRetentionPeriodRequest.getStreamName());
            }
            if (increaseStreamRetentionPeriodRequest.getRetentionPeriodHours() != null) {
                jsonGenerator.writeFieldName("RetentionPeriodHours").writeValue(increaseStreamRetentionPeriodRequest.getRetentionPeriodHours());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

