/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DetachThingPrincipalRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DetachThingPrincipalRequestMarshaller
implements Marshaller<Request<DetachThingPrincipalRequest>, DetachThingPrincipalRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DetachThingPrincipalRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DetachThingPrincipalRequest> marshall(DetachThingPrincipalRequest detachThingPrincipalRequest) {
        if (detachThingPrincipalRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachThingPrincipalRequest> request = new DefaultRequest<DetachThingPrincipalRequest>(detachThingPrincipalRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (detachThingPrincipalRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString(detachThingPrincipalRequest.getPrincipal()));
        }
        String uriResourcePath = "/things/{thingName}/principals";
        uriResourcePath = uriResourcePath.replace("{thingName}", detachThingPrincipalRequest.getThingName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(detachThingPrincipalRequest.getThingName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

