/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListVaultsRequestMarshaller
implements Marshaller<Request<ListVaultsRequest>, ListVaultsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListVaultsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListVaultsRequest> marshall(ListVaultsRequest listVaultsRequest) {
        if (listVaultsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListVaultsRequest> request = new DefaultRequest<ListVaultsRequest>(listVaultsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults";
        uriResourcePath = uriResourcePath.replace("{accountId}", listVaultsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listVaultsRequest.getAccountId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listVaultsRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listVaultsRequest.getMarker()));
        }
        if (listVaultsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromString(listVaultsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

