/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeVaultRequestMarshaller
implements Marshaller<Request<DescribeVaultRequest>, DescribeVaultRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeVaultRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeVaultRequest> marshall(DescribeVaultRequest describeVaultRequest) {
        if (describeVaultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVaultRequest> request = new DefaultRequest<DescribeVaultRequest>(describeVaultRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}";
        uriResourcePath = uriResourcePath.replace("{accountId}", describeVaultRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeVaultRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", describeVaultRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeVaultRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

