/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateMountTargetRequestMarshaller
implements Marshaller<Request<CreateMountTargetRequest>, CreateMountTargetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateMountTargetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateMountTargetRequest> marshall(CreateMountTargetRequest createMountTargetRequest) {
        if (createMountTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateMountTargetRequest> request = new DefaultRequest<CreateMountTargetRequest>(createMountTargetRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-02-01/mount-targets";
        request.setResourcePath(uriResourcePath);
        try {
            SdkInternalList securityGroupsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createMountTargetRequest.getFileSystemId() != null) {
                jsonGenerator.writeFieldName("FileSystemId").writeValue(createMountTargetRequest.getFileSystemId());
            }
            if (createMountTargetRequest.getSubnetId() != null) {
                jsonGenerator.writeFieldName("SubnetId").writeValue(createMountTargetRequest.getSubnetId());
            }
            if (createMountTargetRequest.getIpAddress() != null) {
                jsonGenerator.writeFieldName("IpAddress").writeValue(createMountTargetRequest.getIpAddress());
            }
            if (!(securityGroupsList = (SdkInternalList)createMountTargetRequest.getSecurityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SecurityGroups");
                jsonGenerator.writeStartArray();
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

