/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeAddressesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeAddressesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeAddressesRequest> {
    private SdkInternalList<String> publicIps;
    private SdkInternalList<Filter> filters;
    private SdkInternalList<String> allocationIds;

    public List<String> getPublicIps() {
        if (this.publicIps == null) {
            this.publicIps = new SdkInternalList();
        }
        return this.publicIps;
    }

    public void setPublicIps(Collection<String> publicIps) {
        if (publicIps == null) {
            this.publicIps = null;
            return;
        }
        this.publicIps = new SdkInternalList<String>(publicIps);
    }

    public DescribeAddressesRequest withPublicIps(String ... publicIps) {
        if (this.publicIps == null) {
            this.setPublicIps(new SdkInternalList<String>(publicIps.length));
        }
        for (String ele : publicIps) {
            this.publicIps.add(ele);
        }
        return this;
    }

    public DescribeAddressesRequest withPublicIps(Collection<String> publicIps) {
        this.setPublicIps(publicIps);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeAddressesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeAddressesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getAllocationIds() {
        if (this.allocationIds == null) {
            this.allocationIds = new SdkInternalList();
        }
        return this.allocationIds;
    }

    public void setAllocationIds(Collection<String> allocationIds) {
        if (allocationIds == null) {
            this.allocationIds = null;
            return;
        }
        this.allocationIds = new SdkInternalList<String>(allocationIds);
    }

    public DescribeAddressesRequest withAllocationIds(String ... allocationIds) {
        if (this.allocationIds == null) {
            this.setAllocationIds(new SdkInternalList<String>(allocationIds.length));
        }
        for (String ele : allocationIds) {
            this.allocationIds.add(ele);
        }
        return this;
    }

    public DescribeAddressesRequest withAllocationIds(Collection<String> allocationIds) {
        this.setAllocationIds(allocationIds);
        return this;
    }

    @Override
    public Request<DescribeAddressesRequest> getDryRunRequest() {
        Request<DescribeAddressesRequest> request = new DescribeAddressesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPublicIps() != null) {
            sb.append("PublicIps: " + this.getPublicIps() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getAllocationIds() != null) {
            sb.append("AllocationIds: " + this.getAllocationIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesRequest)) {
            return false;
        }
        DescribeAddressesRequest other = (DescribeAddressesRequest)obj;
        if (other.getPublicIps() == null ^ this.getPublicIps() == null) {
            return false;
        }
        if (other.getPublicIps() != null && !other.getPublicIps().equals(this.getPublicIps())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getAllocationIds() == null ^ this.getAllocationIds() == null) {
            return false;
        }
        return other.getAllocationIds() == null || other.getAllocationIds().equals(this.getAllocationIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPublicIps() == null ? 0 : this.getPublicIps().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationIds() == null ? 0 : this.getAllocationIds().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAddressesRequest clone() {
        return (DescribeAddressesRequest)super.clone();
    }
}

