/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigInteger;

@DynamoDB
@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBVersionAttribute {
    public String attributeName() default "";

    public static final class Generator<T>
    implements DynamoDBAutoGenerator<T> {
        private final Sequence<T> sequence;

        public Generator(Class<T> targetType, DynamoDBVersionAttribute annotation) {
            this.sequence = Sequences.of(targetType);
        }

        @Override
        public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
            return DynamoDBAutoGenerateStrategy.ALWAYS;
        }

        @Override
        public final T generate(T currentValue) {
            return currentValue == null ? this.sequence.initial() : this.sequence.next(currentValue);
        }

        private static enum Sequences {
            BIGINTEGER(StandardTypeConverters.STRING_TO_BIGINTEGER, new Sequence<BigInteger>(){

                @Override
                public final BigInteger initial() {
                    return BigInteger.ONE;
                }

                @Override
                public final BigInteger next(BigInteger currentValue) {
                    return currentValue.add(BigInteger.ONE);
                }
            }),
            BYTE(StandardTypeConverters.STRING_TO_BYTE, new Sequence<Byte>(){

                @Override
                public final Byte initial() {
                    return (byte)1;
                }

                @Override
                public final Byte next(Byte currentValue) {
                    return (byte)((currentValue + 1) % 127);
                }
            }),
            INTEGER(StandardTypeConverters.STRING_TO_INTEGER, new Sequence<Integer>(){

                @Override
                public final Integer initial() {
                    return 1;
                }

                @Override
                public final Integer next(Integer currentValue) {
                    return currentValue + 1;
                }
            }),
            LONG(StandardTypeConverters.STRING_TO_LONG, new Sequence<Long>(){

                @Override
                public final Long initial() {
                    return 1L;
                }

                @Override
                public final Long next(Long currentValue) {
                    return currentValue + 1L;
                }
            }),
            SHORT(StandardTypeConverters.STRING_TO_SHORT, new Sequence<Short>(){

                @Override
                public final Short initial() {
                    return (short)1;
                }

                @Override
                public final Short next(Short currentValue) {
                    return (short)(currentValue + 1);
                }
            });

            private final StandardTypeConverters standard;
            private final Sequence<?> sequence;

            private Sequences(StandardTypeConverters standard, Sequence<?> sequence) {
                this.standard = standard;
                this.sequence = sequence;
            }

            private static final <T> Sequence<T> of(Class<T> targetType) {
                for (Sequences s : Sequences.values()) {
                    if (!s.standard.isAssignableFrom(String.class, targetType, true)) continue;
                    return s.sequence;
                }
                return new Sequence();
            }
        }

        private static class Sequence<T> {
            private Sequence() {
            }

            public T initial() {
                throw new DynamoDBMappingException("unsupported type for version");
            }

            public T next(T currentValue) {
                throw new DynamoDBMappingException("unsupported type for version");
            }
        }
    }
}

