/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.ListDeploymentsRequest;
import com.amazonaws.services.codedeploy.model.transform.TimeRangeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListDeploymentsRequestMarshaller
implements Marshaller<Request<ListDeploymentsRequest>, ListDeploymentsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDeploymentsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDeploymentsRequest> marshall(ListDeploymentsRequest listDeploymentsRequest) {
        if (listDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDeploymentsRequest> request = new DefaultRequest<ListDeploymentsRequest>(listDeploymentsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.ListDeployments");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList includeOnlyStatusesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDeploymentsRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(listDeploymentsRequest.getApplicationName());
            }
            if (listDeploymentsRequest.getDeploymentGroupName() != null) {
                jsonGenerator.writeFieldName("deploymentGroupName").writeValue(listDeploymentsRequest.getDeploymentGroupName());
            }
            if (!(includeOnlyStatusesList = (SdkInternalList)listDeploymentsRequest.getIncludeOnlyStatuses()).isEmpty() || !includeOnlyStatusesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("includeOnlyStatuses");
                jsonGenerator.writeStartArray();
                for (String includeOnlyStatusesListValue : includeOnlyStatusesList) {
                    if (includeOnlyStatusesListValue == null) continue;
                    jsonGenerator.writeValue(includeOnlyStatusesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listDeploymentsRequest.getCreateTimeRange() != null) {
                jsonGenerator.writeFieldName("createTimeRange");
                TimeRangeJsonMarshaller.getInstance().marshall(listDeploymentsRequest.getCreateTimeRange(), jsonGenerator);
            }
            if (listDeploymentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listDeploymentsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

