/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;

@SdkInternalApi
public final class S3AbortableInputStream
extends SdkFilterInputStream {
    private static final Log LOG = LogFactory.getLog(S3AbortableInputStream.class);
    private final HttpRequestBase httpRequest;
    private final long contentLength;
    private long bytesRead;
    private long markedBytes;

    public S3AbortableInputStream(InputStream in, HttpRequestBase httpRequest, long contentLength) {
        super(in);
        this.httpRequest = httpRequest;
        this.contentLength = contentLength;
    }

    @Override
    public void abort() {
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly(this.in, null);
    }

    @Override
    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value != -1) {
            ++this.bytesRead;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = super.read(b, off, len);
        if (value != -1) {
            this.bytesRead += (long)value;
        }
        return value;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.markedBytes = this.bytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.bytesRead = this.markedBytes;
    }

    @Override
    public void close() throws IOException {
        if (this.bytesRead >= this.contentLength) {
            super.close();
        } else {
            LOG.warn((Object)"Not all bytes were read from the S3ObjectInputStream, aborting HTTP connection. This is likely an error and may result in sub-optimal behavior. Request only the bytes you need via a ranged GET or drain the input stream after use.");
            if (this.httpRequest != null) {
                this.httpRequest.abort();
            }
            IOUtils.closeQuietly(this.in, null);
        }
    }

    @SdkTestInternalApi
    long getBytesRead() {
        return this.bytesRead;
    }
}

