/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.ChannelType;
import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import com.amazonaws.services.pinpoint.model.transform.EndpointRequestMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String address;
    private Map<String, List<String>> attributes;
    private String channelType;
    private EndpointDemographic demographic;
    private String effectiveDate;
    private String endpointStatus;
    private EndpointLocation location;
    private Map<String, Double> metrics;
    private String optOut;
    private String requestId;
    private EndpointUser user;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public EndpointRequest withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public EndpointRequest withAttributes(Map<String, List<String>> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public EndpointRequest addAttributesEntry(String key, List<String> value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, List<String>>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public EndpointRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public EndpointRequest withChannelType(String channelType) {
        this.setChannelType(channelType);
        return this;
    }

    @JsonIgnore
    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType.toString();
    }

    public EndpointRequest withChannelType(ChannelType channelType) {
        this.setChannelType(channelType);
        return this;
    }

    public void setDemographic(EndpointDemographic demographic) {
        this.demographic = demographic;
    }

    public EndpointDemographic getDemographic() {
        return this.demographic;
    }

    public EndpointRequest withDemographic(EndpointDemographic demographic) {
        this.setDemographic(demographic);
        return this;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public EndpointRequest withEffectiveDate(String effectiveDate) {
        this.setEffectiveDate(effectiveDate);
        return this;
    }

    public void setEndpointStatus(String endpointStatus) {
        this.endpointStatus = endpointStatus;
    }

    public String getEndpointStatus() {
        return this.endpointStatus;
    }

    public EndpointRequest withEndpointStatus(String endpointStatus) {
        this.setEndpointStatus(endpointStatus);
        return this;
    }

    public void setLocation(EndpointLocation location) {
        this.location = location;
    }

    public EndpointLocation getLocation() {
        return this.location;
    }

    public EndpointRequest withLocation(EndpointLocation location) {
        this.setLocation(location);
        return this;
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    public EndpointRequest withMetrics(Map<String, Double> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public EndpointRequest addMetricsEntry(String key, Double value) {
        if (null == this.metrics) {
            this.metrics = new HashMap<String, Double>();
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metrics.put(key, value);
        return this;
    }

    public EndpointRequest clearMetricsEntries() {
        this.metrics = null;
        return this;
    }

    public void setOptOut(String optOut) {
        this.optOut = optOut;
    }

    public String getOptOut() {
        return this.optOut;
    }

    public EndpointRequest withOptOut(String optOut) {
        this.setOptOut(optOut);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public EndpointRequest withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public void setUser(EndpointUser user) {
        this.user = user;
    }

    public EndpointUser getUser() {
        return this.user;
    }

    public EndpointRequest withUser(EndpointUser user) {
        this.setUser(user);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getChannelType() != null) {
            sb.append("ChannelType: ").append(this.getChannelType()).append(",");
        }
        if (this.getDemographic() != null) {
            sb.append("Demographic: ").append(this.getDemographic()).append(",");
        }
        if (this.getEffectiveDate() != null) {
            sb.append("EffectiveDate: ").append(this.getEffectiveDate()).append(",");
        }
        if (this.getEndpointStatus() != null) {
            sb.append("EndpointStatus: ").append(this.getEndpointStatus()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getOptOut() != null) {
            sb.append("OptOut: ").append(this.getOptOut()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getUser() != null) {
            sb.append("User: ").append(this.getUser());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointRequest)) {
            return false;
        }
        EndpointRequest other = (EndpointRequest)obj;
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getChannelType() == null ^ this.getChannelType() == null) {
            return false;
        }
        if (other.getChannelType() != null && !other.getChannelType().equals(this.getChannelType())) {
            return false;
        }
        if (other.getDemographic() == null ^ this.getDemographic() == null) {
            return false;
        }
        if (other.getDemographic() != null && !other.getDemographic().equals(this.getDemographic())) {
            return false;
        }
        if (other.getEffectiveDate() == null ^ this.getEffectiveDate() == null) {
            return false;
        }
        if (other.getEffectiveDate() != null && !other.getEffectiveDate().equals(this.getEffectiveDate())) {
            return false;
        }
        if (other.getEndpointStatus() == null ^ this.getEndpointStatus() == null) {
            return false;
        }
        if (other.getEndpointStatus() != null && !other.getEndpointStatus().equals(this.getEndpointStatus())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getOptOut() == null ^ this.getOptOut() == null) {
            return false;
        }
        if (other.getOptOut() != null && !other.getOptOut().equals(this.getOptOut())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        return other.getUser() == null || other.getUser().equals(this.getUser());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getChannelType() == null ? 0 : this.getChannelType().hashCode());
        hashCode = 31 * hashCode + (this.getDemographic() == null ? 0 : this.getDemographic().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveDate() == null ? 0 : this.getEffectiveDate().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointStatus() == null ? 0 : this.getEndpointStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getOptOut() == null ? 0 : this.getOptOut().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        return hashCode;
    }

    public EndpointRequest clone() {
        try {
            return (EndpointRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

