/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.BundleType;
import com.amazonaws.services.codedeploy.model.transform.S3LocationMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

public class S3Location
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private String key;
    private String bundleType;
    private String version;
    private String eTag;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3Location withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public S3Location withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setBundleType(String bundleType) {
        this.bundleType = bundleType;
    }

    public String getBundleType() {
        return this.bundleType;
    }

    public S3Location withBundleType(String bundleType) {
        this.setBundleType(bundleType);
        return this;
    }

    @JsonIgnore
    public void setBundleType(BundleType bundleType) {
        this.bundleType = bundleType.toString();
    }

    public S3Location withBundleType(BundleType bundleType) {
        this.setBundleType(bundleType);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public S3Location withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }

    public S3Location withETag(String eTag) {
        this.setETag(eTag);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getBundleType() != null) {
            sb.append("BundleType: ").append(this.getBundleType()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getETag() != null) {
            sb.append("ETag: ").append(this.getETag());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getBundleType() == null ^ this.getBundleType() == null) {
            return false;
        }
        if (other.getBundleType() != null && !other.getBundleType().equals(this.getBundleType())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getETag() == null ^ this.getETag() == null) {
            return false;
        }
        return other.getETag() == null || other.getETag().equals(this.getETag());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getBundleType() == null ? 0 : this.getBundleType().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getETag() == null ? 0 : this.getETag().hashCode());
        return hashCode;
    }

    public S3Location clone() {
        try {
            return (S3Location)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

