/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.AlarmConfiguration;
import com.amazonaws.services.codedeploy.model.AutoRollbackConfiguration;
import com.amazonaws.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import com.amazonaws.services.codedeploy.model.DeploymentStyle;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.LoadBalancerInfo;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.TriggerConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateDeploymentGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String currentDeploymentGroupName;
    private String newDeploymentGroupName;
    private String deploymentConfigName;
    private SdkInternalList<EC2TagFilter> ec2TagFilters;
    private SdkInternalList<TagFilter> onPremisesInstanceTagFilters;
    private SdkInternalList<String> autoScalingGroups;
    private String serviceRoleArn;
    private SdkInternalList<TriggerConfig> triggerConfigurations;
    private AlarmConfiguration alarmConfiguration;
    private AutoRollbackConfiguration autoRollbackConfiguration;
    private DeploymentStyle deploymentStyle;
    private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private LoadBalancerInfo loadBalancerInfo;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public UpdateDeploymentGroupRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
        this.currentDeploymentGroupName = currentDeploymentGroupName;
    }

    public String getCurrentDeploymentGroupName() {
        return this.currentDeploymentGroupName;
    }

    public UpdateDeploymentGroupRequest withCurrentDeploymentGroupName(String currentDeploymentGroupName) {
        this.setCurrentDeploymentGroupName(currentDeploymentGroupName);
        return this;
    }

    public void setNewDeploymentGroupName(String newDeploymentGroupName) {
        this.newDeploymentGroupName = newDeploymentGroupName;
    }

    public String getNewDeploymentGroupName() {
        return this.newDeploymentGroupName;
    }

    public UpdateDeploymentGroupRequest withNewDeploymentGroupName(String newDeploymentGroupName) {
        this.setNewDeploymentGroupName(newDeploymentGroupName);
        return this;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public UpdateDeploymentGroupRequest withDeploymentConfigName(String deploymentConfigName) {
        this.setDeploymentConfigName(deploymentConfigName);
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new SdkInternalList();
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        this.ec2TagFilters = new SdkInternalList<EC2TagFilter>(ec2TagFilters);
    }

    public UpdateDeploymentGroupRequest withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.ec2TagFilters == null) {
            this.setEc2TagFilters(new SdkInternalList<EC2TagFilter>(ec2TagFilters.length));
        }
        for (EC2TagFilter ele : ec2TagFilters) {
            this.ec2TagFilters.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        this.setEc2TagFilters(ec2TagFilters);
        return this;
    }

    public List<TagFilter> getOnPremisesInstanceTagFilters() {
        if (this.onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = new SdkInternalList();
        }
        return this.onPremisesInstanceTagFilters;
    }

    public void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        if (onPremisesInstanceTagFilters == null) {
            this.onPremisesInstanceTagFilters = null;
            return;
        }
        this.onPremisesInstanceTagFilters = new SdkInternalList<TagFilter>(onPremisesInstanceTagFilters);
    }

    public UpdateDeploymentGroupRequest withOnPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
        if (this.onPremisesInstanceTagFilters == null) {
            this.setOnPremisesInstanceTagFilters(new SdkInternalList<TagFilter>(onPremisesInstanceTagFilters.length));
        }
        for (TagFilter ele : onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
        this.setOnPremisesInstanceTagFilters(onPremisesInstanceTagFilters);
        return this;
    }

    public List<String> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new SdkInternalList();
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new SdkInternalList<String>(autoScalingGroups);
    }

    public UpdateDeploymentGroupRequest withAutoScalingGroups(String ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups(new SdkInternalList<String>(autoScalingGroups.length));
        }
        for (String ele : autoScalingGroups) {
            this.autoScalingGroups.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withAutoScalingGroups(Collection<String> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public UpdateDeploymentGroupRequest withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public List<TriggerConfig> getTriggerConfigurations() {
        if (this.triggerConfigurations == null) {
            this.triggerConfigurations = new SdkInternalList();
        }
        return this.triggerConfigurations;
    }

    public void setTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
        if (triggerConfigurations == null) {
            this.triggerConfigurations = null;
            return;
        }
        this.triggerConfigurations = new SdkInternalList<TriggerConfig>(triggerConfigurations);
    }

    public UpdateDeploymentGroupRequest withTriggerConfigurations(TriggerConfig ... triggerConfigurations) {
        if (this.triggerConfigurations == null) {
            this.setTriggerConfigurations(new SdkInternalList<TriggerConfig>(triggerConfigurations.length));
        }
        for (TriggerConfig ele : triggerConfigurations) {
            this.triggerConfigurations.add(ele);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
        this.setTriggerConfigurations(triggerConfigurations);
        return this;
    }

    public void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.alarmConfiguration = alarmConfiguration;
    }

    public AlarmConfiguration getAlarmConfiguration() {
        return this.alarmConfiguration;
    }

    public UpdateDeploymentGroupRequest withAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.setAlarmConfiguration(alarmConfiguration);
        return this;
    }

    public void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
        this.autoRollbackConfiguration = autoRollbackConfiguration;
    }

    public AutoRollbackConfiguration getAutoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public UpdateDeploymentGroupRequest withAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
        this.setAutoRollbackConfiguration(autoRollbackConfiguration);
        return this;
    }

    public void setDeploymentStyle(DeploymentStyle deploymentStyle) {
        this.deploymentStyle = deploymentStyle;
    }

    public DeploymentStyle getDeploymentStyle() {
        return this.deploymentStyle;
    }

    public UpdateDeploymentGroupRequest withDeploymentStyle(DeploymentStyle deploymentStyle) {
        this.setDeploymentStyle(deploymentStyle);
        return this;
    }

    public void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
        this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
    }

    public BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public UpdateDeploymentGroupRequest withBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
        this.setBlueGreenDeploymentConfiguration(blueGreenDeploymentConfiguration);
        return this;
    }

    public void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
        this.loadBalancerInfo = loadBalancerInfo;
    }

    public LoadBalancerInfo getLoadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public UpdateDeploymentGroupRequest withLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
        this.setLoadBalancerInfo(loadBalancerInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getCurrentDeploymentGroupName() != null) {
            sb.append("CurrentDeploymentGroupName: ").append(this.getCurrentDeploymentGroupName()).append(",");
        }
        if (this.getNewDeploymentGroupName() != null) {
            sb.append("NewDeploymentGroupName: ").append(this.getNewDeploymentGroupName()).append(",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.getDeploymentConfigName()).append(",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(this.getEc2TagFilters()).append(",");
        }
        if (this.getOnPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(this.getOnPremisesInstanceTagFilters()).append(",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.getAutoScalingGroups()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getTriggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(this.getTriggerConfigurations()).append(",");
        }
        if (this.getAlarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.getAlarmConfiguration()).append(",");
        }
        if (this.getAutoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.getAutoRollbackConfiguration()).append(",");
        }
        if (this.getDeploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.getDeploymentStyle()).append(",");
        }
        if (this.getBlueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.getBlueGreenDeploymentConfiguration()).append(",");
        }
        if (this.getLoadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.getLoadBalancerInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getCurrentDeploymentGroupName() == null ^ this.getCurrentDeploymentGroupName() == null) {
            return false;
        }
        if (other.getCurrentDeploymentGroupName() != null && !other.getCurrentDeploymentGroupName().equals(this.getCurrentDeploymentGroupName())) {
            return false;
        }
        if (other.getNewDeploymentGroupName() == null ^ this.getNewDeploymentGroupName() == null) {
            return false;
        }
        if (other.getNewDeploymentGroupName() != null && !other.getNewDeploymentGroupName().equals(this.getNewDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() == null ^ this.getOnPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.getOnPremisesInstanceTagFilters() != null && !other.getOnPremisesInstanceTagFilters().equals(this.getOnPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getTriggerConfigurations() == null ^ this.getTriggerConfigurations() == null) {
            return false;
        }
        if (other.getTriggerConfigurations() != null && !other.getTriggerConfigurations().equals(this.getTriggerConfigurations())) {
            return false;
        }
        if (other.getAlarmConfiguration() == null ^ this.getAlarmConfiguration() == null) {
            return false;
        }
        if (other.getAlarmConfiguration() != null && !other.getAlarmConfiguration().equals(this.getAlarmConfiguration())) {
            return false;
        }
        if (other.getAutoRollbackConfiguration() == null ^ this.getAutoRollbackConfiguration() == null) {
            return false;
        }
        if (other.getAutoRollbackConfiguration() != null && !other.getAutoRollbackConfiguration().equals(this.getAutoRollbackConfiguration())) {
            return false;
        }
        if (other.getDeploymentStyle() == null ^ this.getDeploymentStyle() == null) {
            return false;
        }
        if (other.getDeploymentStyle() != null && !other.getDeploymentStyle().equals(this.getDeploymentStyle())) {
            return false;
        }
        if (other.getBlueGreenDeploymentConfiguration() == null ^ this.getBlueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.getBlueGreenDeploymentConfiguration() != null && !other.getBlueGreenDeploymentConfiguration().equals(this.getBlueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.getLoadBalancerInfo() == null ^ this.getLoadBalancerInfo() == null) {
            return false;
        }
        return other.getLoadBalancerInfo() == null || other.getLoadBalancerInfo().equals(this.getLoadBalancerInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentDeploymentGroupName() == null ? 0 : this.getCurrentDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getNewDeploymentGroupName() == null ? 0 : this.getNewDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOnPremisesInstanceTagFilters() == null ? 0 : this.getOnPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerConfigurations() == null ? 0 : this.getTriggerConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmConfiguration() == null ? 0 : this.getAlarmConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoRollbackConfiguration() == null ? 0 : this.getAutoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentStyle() == null ? 0 : this.getDeploymentStyle().hashCode());
        hashCode = 31 * hashCode + (this.getBlueGreenDeploymentConfiguration() == null ? 0 : this.getBlueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerInfo() == null ? 0 : this.getLoadBalancerInfo().hashCode());
        return hashCode;
    }

    @Override
    public UpdateDeploymentGroupRequest clone() {
        return (UpdateDeploymentGroupRequest)super.clone();
    }
}

