/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.ListDeliveryStreamsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListDeliveryStreamsRequestMarshaller
implements Marshaller<Request<ListDeliveryStreamsRequest>, ListDeliveryStreamsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDeliveryStreamsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDeliveryStreamsRequest> marshall(ListDeliveryStreamsRequest listDeliveryStreamsRequest) {
        if (listDeliveryStreamsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDeliveryStreamsRequest> request = new DefaultRequest<ListDeliveryStreamsRequest>(listDeliveryStreamsRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.ListDeliveryStreams");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDeliveryStreamsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listDeliveryStreamsRequest.getLimit());
            }
            if (listDeliveryStreamsRequest.getExclusiveStartDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartDeliveryStreamName").writeValue(listDeliveryStreamsRequest.getExclusiveStartDeliveryStreamName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

