/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.DescribeAssessmentRunsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeAssessmentRunsRequestMarshaller
implements Marshaller<Request<DescribeAssessmentRunsRequest>, DescribeAssessmentRunsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeAssessmentRunsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeAssessmentRunsRequest> marshall(DescribeAssessmentRunsRequest describeAssessmentRunsRequest) {
        if (describeAssessmentRunsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAssessmentRunsRequest> request = new DefaultRequest<DescribeAssessmentRunsRequest>(describeAssessmentRunsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.DescribeAssessmentRuns");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> assessmentRunArnsList = describeAssessmentRunsRequest.getAssessmentRunArns();
            if (assessmentRunArnsList != null) {
                jsonGenerator.writeFieldName("assessmentRunArns");
                jsonGenerator.writeStartArray();
                for (String assessmentRunArnsListValue : assessmentRunArnsList) {
                    if (assessmentRunArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentRunArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

