/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystem;
import com.amazonaws.services.elasticfilesystem.model.BadRequestException;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DependencyTimeoutException;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsResult;
import com.amazonaws.services.elasticfilesystem.model.FileSystemAlreadyExistsException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemInUseException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.IncorrectFileSystemLifeCycleStateException;
import com.amazonaws.services.elasticfilesystem.model.IncorrectMountTargetStateException;
import com.amazonaws.services.elasticfilesystem.model.InternalServerErrorException;
import com.amazonaws.services.elasticfilesystem.model.IpAddressInUseException;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.MountTargetConflictException;
import com.amazonaws.services.elasticfilesystem.model.MountTargetNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.NetworkInterfaceLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.NoFreeAddressesInSubnetException;
import com.amazonaws.services.elasticfilesystem.model.SecurityGroupLimitExceededException;
import com.amazonaws.services.elasticfilesystem.model.SecurityGroupNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.SubnetNotFoundException;
import com.amazonaws.services.elasticfilesystem.model.UnsupportedAvailabilityZoneException;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateFileSystemRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateFileSystemResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateMountTargetRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateMountTargetResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateTagsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.CreateTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteFileSystemRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteFileSystemResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteMountTargetRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteMountTargetResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteTagsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DeleteTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeFileSystemsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeFileSystemsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetSecurityGroupsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetSecurityGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeMountTargetsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeTagsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.DescribeTagsResultJsonUnmarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.ModifyMountTargetSecurityGroupsRequestMarshaller;
import com.amazonaws.services.elasticfilesystem.model.transform.ModifyMountTargetSecurityGroupsResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonElasticFileSystemClient
extends AmazonWebServiceClient
implements AmazonElasticFileSystem {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticFileSystem.class);
    private static final String DEFAULT_SIGNING_NAME = "elasticfilesystem";
    private static final String DEFAULT_ENDPOINT_PREFIX = "elasticfilesystem";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemInUse").withModeledClass(FileSystemInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectFileSystemLifeCycleState").withModeledClass(IncorrectFileSystemLifeCycleStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SecurityGroupNotFound").withModeledClass(SecurityGroupNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SubnetNotFound").withModeledClass(SubnetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyTimeout").withModeledClass(DependencyTimeoutException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemNotFound").withModeledClass(FileSystemNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedAvailabilityZone").withModeledClass(UnsupportedAvailabilityZoneException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IpAddressInUse").withModeledClass(IpAddressInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("SecurityGroupLimitExceeded").withModeledClass(SecurityGroupLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MountTargetConflict").withModeledClass(MountTargetConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoFreeAddressesInSubnet").withModeledClass(NoFreeAddressesInSubnetException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequest").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NetworkInterfaceLimitExceeded").withModeledClass(NetworkInterfaceLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemAlreadyExists").withModeledClass(FileSystemAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MountTargetNotFound").withModeledClass(MountTargetNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IncorrectMountTargetState").withModeledClass(IncorrectMountTargetStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("FileSystemLimitExceeded").withModeledClass(FileSystemLimitExceededException.class)));

    public AmazonElasticFileSystemClient() {
        this(new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonElasticFileSystemClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticFileSystemClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonElasticFileSystemClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticFileSystemClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonElasticFileSystemClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonElasticFileSystemClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.setServiceNameIntern("elasticfilesystem");
        this.setEndpointPrefix("elasticfilesystem");
        this.setEndpoint("https://elasticfilesystem.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticfilesystem/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/elasticfilesystem/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFileSystemResult createFileSystem(CreateFileSystemRequest createFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateFileSystemRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateFileSystemResult createFileSystemResult = (CreateFileSystemResult)response.getAwsResponse();
            return createFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMountTargetResult createMountTarget(CreateMountTargetRequest createMountTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMountTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMountTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMountTargetRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createMountTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateMountTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMountTargetResult createMountTargetResult = (CreateMountTargetResult)response.getAwsResponse();
            return createMountTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResult createTags(CreateTagsRequest createTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTagsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTagsResult createTagsResult = (CreateTagsResult)response.getAwsResponse();
            return createTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFileSystemResult deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFileSystemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFileSystemRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFileSystemRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteFileSystemRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteFileSystemResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFileSystemResult deleteFileSystemResult = (DeleteFileSystemResult)response.getAwsResponse();
            return deleteFileSystemResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMountTargetResult deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMountTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMountTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMountTargetRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteMountTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteMountTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMountTargetResult deleteMountTargetResult = (DeleteMountTargetResult)response.getAwsResponse();
            return deleteMountTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResult deleteTags(DeleteTagsRequest deleteTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTagsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTagsResult deleteTagsResult = (DeleteTagsResult)response.getAwsResponse();
            return deleteTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFileSystemsResult describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFileSystemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFileSystemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFileSystemsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeFileSystemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeFileSystemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFileSystemsResult describeFileSystemsResult = (DescribeFileSystemsResult)response.getAwsResponse();
            return describeFileSystemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFileSystemsResult describeFileSystems() {
        return this.describeFileSystems(new DescribeFileSystemsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMountTargetSecurityGroupsResult describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMountTargetSecurityGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMountTargetSecurityGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMountTargetSecurityGroupsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeMountTargetSecurityGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeMountTargetSecurityGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMountTargetSecurityGroupsResult describeMountTargetSecurityGroupsResult = (DescribeMountTargetSecurityGroupsResult)response.getAwsResponse();
            return describeMountTargetSecurityGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMountTargetsResult describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMountTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMountTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMountTargetsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeMountTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeMountTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMountTargetsResult describeMountTargetsResult = (DescribeMountTargetsResult)response.getAwsResponse();
            return describeMountTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResult describeTags(DescribeTagsRequest describeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTagsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTagsResult describeTagsResult = (DescribeTagsResult)response.getAwsResponse();
            return describeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyMountTargetSecurityGroupsResult modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyMountTargetSecurityGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyMountTargetSecurityGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyMountTargetSecurityGroupsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(modifyMountTargetSecurityGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ModifyMountTargetSecurityGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyMountTargetSecurityGroupsResult modifyMountTargetSecurityGroupsResult = (ModifyMountTargetSecurityGroupsResult)response.getAwsResponse();
            return modifyMountTargetSecurityGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

