/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.PutImageRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutImageRequestMarshaller
implements Marshaller<Request<PutImageRequest>, PutImageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutImageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutImageRequest> marshall(PutImageRequest putImageRequest) {
        if (putImageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutImageRequest> request = new DefaultRequest<PutImageRequest>(putImageRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.PutImage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putImageRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(putImageRequest.getRegistryId());
            }
            if (putImageRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(putImageRequest.getRepositoryName());
            }
            if (putImageRequest.getImageManifest() != null) {
                jsonGenerator.writeFieldName("imageManifest").writeValue(putImageRequest.getImageManifest());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

