/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ChangePasswordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ChangePasswordRequestMarshaller
implements Marshaller<Request<ChangePasswordRequest>, ChangePasswordRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ChangePasswordRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ChangePasswordRequest> marshall(ChangePasswordRequest changePasswordRequest) {
        if (changePasswordRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ChangePasswordRequest> request = new DefaultRequest<ChangePasswordRequest>(changePasswordRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ChangePassword");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (changePasswordRequest.getPreviousPassword() != null) {
                jsonGenerator.writeFieldName("PreviousPassword").writeValue(changePasswordRequest.getPreviousPassword());
            }
            if (changePasswordRequest.getProposedPassword() != null) {
                jsonGenerator.writeFieldName("ProposedPassword").writeValue(changePasswordRequest.getProposedPassword());
            }
            if (changePasswordRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(changePasswordRequest.getAccessToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

