/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.CreateRepositoryRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateRepositoryRequestMarshaller
implements Marshaller<Request<CreateRepositoryRequest>, CreateRepositoryRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateRepositoryRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateRepositoryRequest> marshall(CreateRepositoryRequest createRepositoryRequest) {
        if (createRepositoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRepositoryRequest> request = new DefaultRequest<CreateRepositoryRequest>(createRepositoryRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.CreateRepository");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createRepositoryRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(createRepositoryRequest.getRepositoryName());
            }
            if (createRepositoryRequest.getRepositoryDescription() != null) {
                jsonGenerator.writeFieldName("repositoryDescription").writeValue(createRepositoryRequest.getRepositoryDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

