/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteIntegrationRequestMarshaller
implements Marshaller<Request<DeleteIntegrationRequest>, DeleteIntegrationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteIntegrationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteIntegrationRequest> marshall(DeleteIntegrationRequest deleteIntegrationRequest) {
        if (deleteIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteIntegrationRequest> request = new DefaultRequest<DeleteIntegrationRequest>(deleteIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteIntegrationRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteIntegrationRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteIntegrationRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationRequest.getHttpMethod()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

