/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.storagegateway.model.DescribeTapesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeTapesRequestMarshaller
implements Marshaller<Request<DescribeTapesRequest>, DescribeTapesRequest> {
    @Override
    public Request<DescribeTapesRequest> marshall(DescribeTapesRequest describeTapesRequest) {
        if (describeTapesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTapesRequest> request = new DefaultRequest<DescribeTapesRequest>(describeTapesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.DescribeTapes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tapeARNsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (describeTapesRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(describeTapesRequest.getGatewayARN());
            }
            if (!(tapeARNsList = (SdkInternalList)describeTapesRequest.getTapeARNs()).isEmpty() || !tapeARNsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TapeARNs");
                jsonGenerator.writeStartArray();
                for (String tapeARNsListValue : tapeARNsList) {
                    if (tapeARNsListValue == null) continue;
                    jsonGenerator.writeValue(tapeARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeTapesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(describeTapesRequest.getMarker());
            }
            if (describeTapesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeTapesRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

