/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.Tag;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateTagsForDomainRequestMarshaller
implements Marshaller<Request<UpdateTagsForDomainRequest>, UpdateTagsForDomainRequest> {
    @Override
    public Request<UpdateTagsForDomainRequest> marshall(UpdateTagsForDomainRequest updateTagsForDomainRequest) {
        if (updateTagsForDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTagsForDomainRequest> request = new DefaultRequest<UpdateTagsForDomainRequest>(updateTagsForDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.UpdateTagsForDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsToUpdateList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (updateTagsForDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(updateTagsForDomainRequest.getDomainName());
            }
            if (!(tagsToUpdateList = (SdkInternalList)updateTagsForDomainRequest.getTagsToUpdate()).isEmpty() || !tagsToUpdateList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TagsToUpdate");
                jsonGenerator.writeStartArray();
                for (Tag tagsToUpdateListValue : tagsToUpdateList) {
                    if (tagsToUpdateListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsToUpdateListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

