/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeVolumesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    @Override
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        if (describeVolumesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVolumesRequest> request = new DefaultRequest<DescribeVolumesRequest>(describeVolumesRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeVolumes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumeIdsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (describeVolumesRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeVolumesRequest.getInstanceId());
            }
            if (describeVolumesRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeVolumesRequest.getStackId());
            }
            if (describeVolumesRequest.getRaidArrayId() != null) {
                jsonGenerator.writeFieldName("RaidArrayId").writeValue(describeVolumesRequest.getRaidArrayId());
            }
            if (!(volumeIdsList = (SdkInternalList)describeVolumesRequest.getVolumeIds()).isEmpty() || !volumeIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("VolumeIds");
                jsonGenerator.writeStartArray();
                for (String volumeIdsListValue : volumeIdsList) {
                    if (volumeIdsListValue == null) continue;
                    jsonGenerator.writeValue(volumeIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

