/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.UpdateFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.transform.VpcConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateFunctionConfigurationRequestMarshaller
implements Marshaller<Request<UpdateFunctionConfigurationRequest>, UpdateFunctionConfigurationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateFunctionConfigurationRequest> marshall(UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        if (updateFunctionConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFunctionConfigurationRequest> request = new DefaultRequest<UpdateFunctionConfigurationRequest>(updateFunctionConfigurationRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/configuration";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", updateFunctionConfigurationRequest.getFunctionName() != null ? StringUtils.fromString(updateFunctionConfigurationRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateFunctionConfigurationRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(updateFunctionConfigurationRequest.getRole());
            }
            if (updateFunctionConfigurationRequest.getHandler() != null) {
                jsonGenerator.writeFieldName("Handler").writeValue(updateFunctionConfigurationRequest.getHandler());
            }
            if (updateFunctionConfigurationRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateFunctionConfigurationRequest.getDescription());
            }
            if (updateFunctionConfigurationRequest.getTimeout() != null) {
                jsonGenerator.writeFieldName("Timeout").writeValue(updateFunctionConfigurationRequest.getTimeout());
            }
            if (updateFunctionConfigurationRequest.getMemorySize() != null) {
                jsonGenerator.writeFieldName("MemorySize").writeValue(updateFunctionConfigurationRequest.getMemorySize());
            }
            if (updateFunctionConfigurationRequest.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigJsonMarshaller.getInstance().marshall(updateFunctionConfigurationRequest.getVpcConfig(), jsonGenerator);
            }
            if (updateFunctionConfigurationRequest.getRuntime() != null) {
                jsonGenerator.writeFieldName("Runtime").writeValue(updateFunctionConfigurationRequest.getRuntime());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

