/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class UpdateEventSourceMappingRequestMarshaller
implements Marshaller<Request<UpdateEventSourceMappingRequest>, UpdateEventSourceMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateEventSourceMappingRequest> marshall(UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        if (updateEventSourceMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateEventSourceMappingRequest> request = new DefaultRequest<UpdateEventSourceMappingRequest>(updateEventSourceMappingRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/event-source-mappings/{UUID}";
        uriResourcePath = uriResourcePath.replace("{UUID}", updateEventSourceMappingRequest.getUUID() != null ? StringUtils.fromString(updateEventSourceMappingRequest.getUUID()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateEventSourceMappingRequest.getFunctionName() != null) {
                jsonGenerator.writeFieldName("FunctionName").writeValue(updateEventSourceMappingRequest.getFunctionName());
            }
            if (updateEventSourceMappingRequest.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(updateEventSourceMappingRequest.getEnabled());
            }
            if (updateEventSourceMappingRequest.getBatchSize() != null) {
                jsonGenerator.writeFieldName("BatchSize").writeValue(updateEventSourceMappingRequest.getBatchSize());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

