/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.RemovePermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        if (removePermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RemovePermissionRequest> request = new DefaultRequest<RemovePermissionRequest>(removePermissionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/policy/{StatementId}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", removePermissionRequest.getFunctionName() != null ? StringUtils.fromString(removePermissionRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{StatementId}", removePermissionRequest.getStatementId() != null ? StringUtils.fromString(removePermissionRequest.getStatementId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (removePermissionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString(removePermissionRequest.getQualifier()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

