/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import com.amazonaws.services.lambda.model.transform.VpcConfigResponseJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class FunctionConfigurationJsonMarshaller {
    private static FunctionConfigurationJsonMarshaller instance;

    public void marshall(FunctionConfiguration functionConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (functionConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (functionConfiguration.getFunctionName() != null) {
                jsonGenerator.writeFieldName("FunctionName").writeValue(functionConfiguration.getFunctionName());
            }
            if (functionConfiguration.getFunctionArn() != null) {
                jsonGenerator.writeFieldName("FunctionArn").writeValue(functionConfiguration.getFunctionArn());
            }
            if (functionConfiguration.getRuntime() != null) {
                jsonGenerator.writeFieldName("Runtime").writeValue(functionConfiguration.getRuntime());
            }
            if (functionConfiguration.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(functionConfiguration.getRole());
            }
            if (functionConfiguration.getHandler() != null) {
                jsonGenerator.writeFieldName("Handler").writeValue(functionConfiguration.getHandler());
            }
            if (functionConfiguration.getCodeSize() != null) {
                jsonGenerator.writeFieldName("CodeSize").writeValue(functionConfiguration.getCodeSize());
            }
            if (functionConfiguration.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(functionConfiguration.getDescription());
            }
            if (functionConfiguration.getTimeout() != null) {
                jsonGenerator.writeFieldName("Timeout").writeValue(functionConfiguration.getTimeout());
            }
            if (functionConfiguration.getMemorySize() != null) {
                jsonGenerator.writeFieldName("MemorySize").writeValue(functionConfiguration.getMemorySize());
            }
            if (functionConfiguration.getLastModified() != null) {
                jsonGenerator.writeFieldName("LastModified").writeValue(functionConfiguration.getLastModified());
            }
            if (functionConfiguration.getCodeSha256() != null) {
                jsonGenerator.writeFieldName("CodeSha256").writeValue(functionConfiguration.getCodeSha256());
            }
            if (functionConfiguration.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(functionConfiguration.getVersion());
            }
            if (functionConfiguration.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigResponseJsonMarshaller.getInstance().marshall(functionConfiguration.getVpcConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FunctionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

