/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ListKeyPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListKeyPoliciesRequestMarshaller
implements Marshaller<Request<ListKeyPoliciesRequest>, ListKeyPoliciesRequest> {
    @Override
    public Request<ListKeyPoliciesRequest> marshall(ListKeyPoliciesRequest listKeyPoliciesRequest) {
        if (listKeyPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListKeyPoliciesRequest> request = new DefaultRequest<ListKeyPoliciesRequest>(listKeyPoliciesRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListKeyPolicies");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listKeyPoliciesRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(listKeyPoliciesRequest.getKeyId());
            }
            if (listKeyPoliciesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listKeyPoliciesRequest.getLimit());
            }
            if (listKeyPoliciesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listKeyPoliciesRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

