/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.SetDefaultPolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class SetDefaultPolicyVersionRequestMarshaller
implements Marshaller<Request<SetDefaultPolicyVersionRequest>, SetDefaultPolicyVersionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<SetDefaultPolicyVersionRequest> marshall(SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest) {
        if (setDefaultPolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetDefaultPolicyVersionRequest> request = new DefaultRequest<SetDefaultPolicyVersionRequest>(setDefaultPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = uriResourcePath.replace("{policyName}", setDefaultPolicyVersionRequest.getPolicyName() != null ? StringUtils.fromString(setDefaultPolicyVersionRequest.getPolicyName()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{policyVersionId}", setDefaultPolicyVersionRequest.getPolicyVersionId() != null ? StringUtils.fromString(setDefaultPolicyVersionRequest.getPolicyVersionId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

