/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.CreateCertificateFromCsrRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateCertificateFromCsrRequestMarshaller
implements Marshaller<Request<CreateCertificateFromCsrRequest>, CreateCertificateFromCsrRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateCertificateFromCsrRequest> marshall(CreateCertificateFromCsrRequest createCertificateFromCsrRequest) {
        if (createCertificateFromCsrRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCertificateFromCsrRequest> request = new DefaultRequest<CreateCertificateFromCsrRequest>(createCertificateFromCsrRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/certificates";
        request.setResourcePath(uriResourcePath);
        if (createCertificateFromCsrRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean(createCertificateFromCsrRequest.getSetAsActive()));
        }
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createCertificateFromCsrRequest.getCertificateSigningRequest() != null) {
                jsonGenerator.writeFieldName("certificateSigningRequest").writeValue(createCertificateFromCsrRequest.getCertificateSigningRequest());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

