/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.ResourceGroupTag;
import com.amazonaws.services.inspector.model.transform.ResourceGroupTagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateResourceGroupRequestMarshaller
implements Marshaller<Request<CreateResourceGroupRequest>, CreateResourceGroupRequest> {
    @Override
    public Request<CreateResourceGroupRequest> marshall(CreateResourceGroupRequest createResourceGroupRequest) {
        if (createResourceGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateResourceGroupRequest> request = new DefaultRequest<CreateResourceGroupRequest>(createResourceGroupRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateResourceGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<ResourceGroupTag> resourceGroupTagsList = createResourceGroupRequest.getResourceGroupTags();
            if (resourceGroupTagsList != null) {
                jsonGenerator.writeFieldName("resourceGroupTags");
                jsonGenerator.writeStartArray();
                for (ResourceGroupTag resourceGroupTagsListValue : resourceGroupTagsList) {
                    if (resourceGroupTagsListValue == null) continue;
                    ResourceGroupTagJsonMarshaller.getInstance().marshall(resourceGroupTagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

