/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.CreateAssessmentTemplateRequest;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateAssessmentTemplateRequestMarshaller
implements Marshaller<Request<CreateAssessmentTemplateRequest>, CreateAssessmentTemplateRequest> {
    @Override
    public Request<CreateAssessmentTemplateRequest> marshall(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        if (createAssessmentTemplateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAssessmentTemplateRequest> request = new DefaultRequest<CreateAssessmentTemplateRequest>(createAssessmentTemplateRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.CreateAssessmentTemplate");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> userAttributesForFindingsList;
            List<String> rulesPackageArnsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createAssessmentTemplateRequest.getAssessmentTargetArn() != null) {
                jsonGenerator.writeFieldName("assessmentTargetArn").writeValue(createAssessmentTemplateRequest.getAssessmentTargetArn());
            }
            if (createAssessmentTemplateRequest.getAssessmentTemplateName() != null) {
                jsonGenerator.writeFieldName("assessmentTemplateName").writeValue(createAssessmentTemplateRequest.getAssessmentTemplateName());
            }
            if (createAssessmentTemplateRequest.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue(createAssessmentTemplateRequest.getDurationInSeconds());
            }
            if ((rulesPackageArnsList = createAssessmentTemplateRequest.getRulesPackageArns()) != null) {
                jsonGenerator.writeFieldName("rulesPackageArns");
                jsonGenerator.writeStartArray();
                for (String rulesPackageArnsListValue : rulesPackageArnsList) {
                    if (rulesPackageArnsListValue == null) continue;
                    jsonGenerator.writeValue(rulesPackageArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesForFindingsList = createAssessmentTemplateRequest.getUserAttributesForFindings()) != null) {
                jsonGenerator.writeFieldName("userAttributesForFindings");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesForFindingsListValue : userAttributesForFindingsList) {
                    if (userAttributesForFindingsListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesForFindingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

