/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.AgentFilter;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.List;

public class AgentFilterJsonMarshaller {
    private static AgentFilterJsonMarshaller instance;

    public void marshall(AgentFilter agentFilter, StructuredJsonGenerator jsonGenerator) {
        if (agentFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> agentHealthCodesList;
            jsonGenerator.writeStartObject();
            List<String> agentHealthsList = agentFilter.getAgentHealths();
            if (agentHealthsList != null) {
                jsonGenerator.writeFieldName("agentHealths");
                jsonGenerator.writeStartArray();
                for (String agentHealthsListValue : agentHealthsList) {
                    if (agentHealthsListValue == null) continue;
                    jsonGenerator.writeValue(agentHealthsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((agentHealthCodesList = agentFilter.getAgentHealthCodes()) != null) {
                jsonGenerator.writeFieldName("agentHealthCodes");
                jsonGenerator.writeStartArray();
                for (String agentHealthCodesListValue : agentHealthCodesList) {
                    if (agentHealthCodesListValue == null) continue;
                    jsonGenerator.writeValue(agentHealthCodesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AgentFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AgentFilterJsonMarshaller();
        }
        return instance;
    }
}

