/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.DescribeFleetAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeFleetAttributesRequestMarshaller
implements Marshaller<Request<DescribeFleetAttributesRequest>, DescribeFleetAttributesRequest> {
    @Override
    public Request<DescribeFleetAttributesRequest> marshall(DescribeFleetAttributesRequest describeFleetAttributesRequest) {
        if (describeFleetAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetAttributesRequest> request = new DefaultRequest<DescribeFleetAttributesRequest>(describeFleetAttributesRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<String> fleetIdsList = describeFleetAttributesRequest.getFleetIds();
            if (fleetIdsList != null) {
                jsonGenerator.writeFieldName("FleetIds");
                jsonGenerator.writeStartArray();
                for (String fleetIdsListValue : fleetIdsList) {
                    if (fleetIdsListValue == null) continue;
                    jsonGenerator.writeValue(fleetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeFleetAttributesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeFleetAttributesRequest.getLimit());
            }
            if (describeFleetAttributesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeFleetAttributesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

