/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.CreateBuildRequest;
import com.amazonaws.services.gamelift.model.transform.S3LocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateBuildRequestMarshaller
implements Marshaller<Request<CreateBuildRequest>, CreateBuildRequest> {
    @Override
    public Request<CreateBuildRequest> marshall(CreateBuildRequest createBuildRequest) {
        if (createBuildRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateBuildRequest> request = new DefaultRequest<CreateBuildRequest>(createBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createBuildRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createBuildRequest.getName());
            }
            if (createBuildRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(createBuildRequest.getVersion());
            }
            if (createBuildRequest.getStorageLocation() != null) {
                jsonGenerator.writeFieldName("StorageLocation");
                S3LocationJsonMarshaller.getInstance().marshall(createBuildRequest.getStorageLocation(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

