/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.AZMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyCacheClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cacheClusterId;
    private Integer numCacheNodes;
    private ListWithAutoConstructFlag<String> cacheNodeIdsToRemove;
    private String aZMode;
    private ListWithAutoConstructFlag<String> newAvailabilityZones;
    private ListWithAutoConstructFlag<String> cacheSecurityGroupNames;
    private ListWithAutoConstructFlag<String> securityGroupIds;
    private String preferredMaintenanceWindow;
    private String notificationTopicArn;
    private String cacheParameterGroupName;
    private String notificationTopicStatus;
    private Boolean applyImmediately;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private String cacheNodeType;

    public ModifyCacheClusterRequest() {
    }

    public ModifyCacheClusterRequest(String cacheClusterId) {
        this.setCacheClusterId(cacheClusterId);
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public ModifyCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public ModifyCacheClusterRequest withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public List<String> getCacheNodeIdsToRemove() {
        if (this.cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = new ListWithAutoConstructFlag();
            this.cacheNodeIdsToRemove.setAutoConstruct(true);
        }
        return this.cacheNodeIdsToRemove;
    }

    public void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
            return;
        }
        ListWithAutoConstructFlag cacheNodeIdsToRemoveCopy = new ListWithAutoConstructFlag(cacheNodeIdsToRemove.size());
        cacheNodeIdsToRemoveCopy.addAll(cacheNodeIdsToRemove);
        this.cacheNodeIdsToRemove = cacheNodeIdsToRemoveCopy;
    }

    public ModifyCacheClusterRequest withCacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
        if (this.getCacheNodeIdsToRemove() == null) {
            this.setCacheNodeIdsToRemove(new ArrayList<String>(cacheNodeIdsToRemove.length));
        }
        for (String value : cacheNodeIdsToRemove) {
            this.getCacheNodeIdsToRemove().add(value);
        }
        return this;
    }

    public ModifyCacheClusterRequest withCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
        } else {
            ListWithAutoConstructFlag cacheNodeIdsToRemoveCopy = new ListWithAutoConstructFlag(cacheNodeIdsToRemove.size());
            cacheNodeIdsToRemoveCopy.addAll(cacheNodeIdsToRemove);
            this.cacheNodeIdsToRemove = cacheNodeIdsToRemoveCopy;
        }
        return this;
    }

    public String getAZMode() {
        return this.aZMode;
    }

    public void setAZMode(String aZMode) {
        this.aZMode = aZMode;
    }

    public ModifyCacheClusterRequest withAZMode(String aZMode) {
        this.aZMode = aZMode;
        return this;
    }

    public void setAZMode(AZMode aZMode) {
        this.aZMode = aZMode.toString();
    }

    public ModifyCacheClusterRequest withAZMode(AZMode aZMode) {
        this.aZMode = aZMode.toString();
        return this;
    }

    public List<String> getNewAvailabilityZones() {
        if (this.newAvailabilityZones == null) {
            this.newAvailabilityZones = new ListWithAutoConstructFlag();
            this.newAvailabilityZones.setAutoConstruct(true);
        }
        return this.newAvailabilityZones;
    }

    public void setNewAvailabilityZones(Collection<String> newAvailabilityZones) {
        if (newAvailabilityZones == null) {
            this.newAvailabilityZones = null;
            return;
        }
        ListWithAutoConstructFlag newAvailabilityZonesCopy = new ListWithAutoConstructFlag(newAvailabilityZones.size());
        newAvailabilityZonesCopy.addAll(newAvailabilityZones);
        this.newAvailabilityZones = newAvailabilityZonesCopy;
    }

    public ModifyCacheClusterRequest withNewAvailabilityZones(String ... newAvailabilityZones) {
        if (this.getNewAvailabilityZones() == null) {
            this.setNewAvailabilityZones(new ArrayList<String>(newAvailabilityZones.length));
        }
        for (String value : newAvailabilityZones) {
            this.getNewAvailabilityZones().add(value);
        }
        return this;
    }

    public ModifyCacheClusterRequest withNewAvailabilityZones(Collection<String> newAvailabilityZones) {
        if (newAvailabilityZones == null) {
            this.newAvailabilityZones = null;
        } else {
            ListWithAutoConstructFlag newAvailabilityZonesCopy = new ListWithAutoConstructFlag(newAvailabilityZones.size());
            newAvailabilityZonesCopy.addAll(newAvailabilityZones);
            this.newAvailabilityZones = newAvailabilityZonesCopy;
        }
        return this;
    }

    public List<String> getCacheSecurityGroupNames() {
        if (this.cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = new ListWithAutoConstructFlag();
            this.cacheSecurityGroupNames.setAutoConstruct(true);
        }
        return this.cacheSecurityGroupNames;
    }

    public void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
            return;
        }
        ListWithAutoConstructFlag cacheSecurityGroupNamesCopy = new ListWithAutoConstructFlag(cacheSecurityGroupNames.size());
        cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
        this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
    }

    public ModifyCacheClusterRequest withCacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
        if (this.getCacheSecurityGroupNames() == null) {
            this.setCacheSecurityGroupNames(new ArrayList<String>(cacheSecurityGroupNames.length));
        }
        for (String value : cacheSecurityGroupNames) {
            this.getCacheSecurityGroupNames().add(value);
        }
        return this;
    }

    public ModifyCacheClusterRequest withCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
        } else {
            ListWithAutoConstructFlag cacheSecurityGroupNamesCopy = new ListWithAutoConstructFlag(cacheSecurityGroupNames.size());
            cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
            this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
        }
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new ListWithAutoConstructFlag();
            this.securityGroupIds.setAutoConstruct(true);
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
        securityGroupIdsCopy.addAll(securityGroupIds);
        this.securityGroupIds = securityGroupIdsCopy;
    }

    public ModifyCacheClusterRequest withSecurityGroupIds(String ... securityGroupIds) {
        if (this.getSecurityGroupIds() == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String value : securityGroupIds) {
            this.getSecurityGroupIds().add(value);
        }
        return this;
    }

    public ModifyCacheClusterRequest withSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
        } else {
            ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
            securityGroupIdsCopy.addAll(securityGroupIds);
            this.securityGroupIds = securityGroupIdsCopy;
        }
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public ModifyCacheClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public String getNotificationTopicArn() {
        return this.notificationTopicArn;
    }

    public void setNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
    }

    public ModifyCacheClusterRequest withNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
        return this;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public ModifyCacheClusterRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public String getNotificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public void setNotificationTopicStatus(String notificationTopicStatus) {
        this.notificationTopicStatus = notificationTopicStatus;
    }

    public ModifyCacheClusterRequest withNotificationTopicStatus(String notificationTopicStatus) {
        this.notificationTopicStatus = notificationTopicStatus;
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public ModifyCacheClusterRequest withApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
        return this;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public ModifyCacheClusterRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public ModifyCacheClusterRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public ModifyCacheClusterRequest withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
        return this;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public ModifyCacheClusterRequest withSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public ModifyCacheClusterRequest withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: " + this.getCacheClusterId() + ",");
        }
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: " + this.getNumCacheNodes() + ",");
        }
        if (this.getCacheNodeIdsToRemove() != null) {
            sb.append("CacheNodeIdsToRemove: " + this.getCacheNodeIdsToRemove() + ",");
        }
        if (this.getAZMode() != null) {
            sb.append("AZMode: " + this.getAZMode() + ",");
        }
        if (this.getNewAvailabilityZones() != null) {
            sb.append("NewAvailabilityZones: " + this.getNewAvailabilityZones() + ",");
        }
        if (this.getCacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: " + this.getCacheSecurityGroupNames() + ",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: " + this.getSecurityGroupIds() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getNotificationTopicArn() != null) {
            sb.append("NotificationTopicArn: " + this.getNotificationTopicArn() + ",");
        }
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: " + this.getCacheParameterGroupName() + ",");
        }
        if (this.getNotificationTopicStatus() != null) {
            sb.append("NotificationTopicStatus: " + this.getNotificationTopicStatus() + ",");
        }
        if (this.isApplyImmediately() != null) {
            sb.append("ApplyImmediately: " + this.isApplyImmediately() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade() + ",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: " + this.getSnapshotRetentionLimit() + ",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: " + this.getSnapshotWindow() + ",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: " + this.getCacheNodeType());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeIdsToRemove() == null ? 0 : this.getCacheNodeIdsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getAZMode() == null ? 0 : this.getAZMode().hashCode());
        hashCode = 31 * hashCode + (this.getNewAvailabilityZones() == null ? 0 : this.getNewAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroupNames() == null ? 0 : this.getCacheSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicArn() == null ? 0 : this.getNotificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicStatus() == null ? 0 : this.getNotificationTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.isApplyImmediately() == null ? 0 : this.isApplyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheClusterRequest)) {
            return false;
        }
        ModifyCacheClusterRequest other = (ModifyCacheClusterRequest)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() == null ^ this.getCacheNodeIdsToRemove() == null) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() != null && !other.getCacheNodeIdsToRemove().equals(this.getCacheNodeIdsToRemove())) {
            return false;
        }
        if (other.getAZMode() == null ^ this.getAZMode() == null) {
            return false;
        }
        if (other.getAZMode() != null && !other.getAZMode().equals(this.getAZMode())) {
            return false;
        }
        if (other.getNewAvailabilityZones() == null ^ this.getNewAvailabilityZones() == null) {
            return false;
        }
        if (other.getNewAvailabilityZones() != null && !other.getNewAvailabilityZones().equals(this.getNewAvailabilityZones())) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() == null ^ this.getCacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() != null && !other.getCacheSecurityGroupNames().equals(this.getCacheSecurityGroupNames())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getNotificationTopicArn() == null ^ this.getNotificationTopicArn() == null) {
            return false;
        }
        if (other.getNotificationTopicArn() != null && !other.getNotificationTopicArn().equals(this.getNotificationTopicArn())) {
            return false;
        }
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getNotificationTopicStatus() == null ^ this.getNotificationTopicStatus() == null) {
            return false;
        }
        if (other.getNotificationTopicStatus() != null && !other.getNotificationTopicStatus().equals(this.getNotificationTopicStatus())) {
            return false;
        }
        if (other.isApplyImmediately() == null ^ this.isApplyImmediately() == null) {
            return false;
        }
        if (other.isApplyImmediately() != null && !other.isApplyImmediately().equals(this.isApplyImmediately())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        return other.getCacheNodeType() == null || other.getCacheNodeType().equals(this.getCacheNodeType());
    }

    @Override
    public ModifyCacheClusterRequest clone() {
        return (ModifyCacheClusterRequest)super.clone();
    }
}

