/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import com.amazonaws.services.datapipeline.model.TaskObject;
import com.amazonaws.services.datapipeline.model.transform.PipelineObjectJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class TaskObjectJsonMarshaller {
    private static TaskObjectJsonMarshaller instance;

    public void marshall(TaskObject taskObject, StructuredJsonGenerator jsonGenerator) {
        if (taskObject == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, PipelineObject> objectsMap;
            jsonGenerator.writeStartObject();
            if (taskObject.getTaskId() != null) {
                jsonGenerator.writeFieldName("taskId").writeValue(taskObject.getTaskId());
            }
            if (taskObject.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(taskObject.getPipelineId());
            }
            if (taskObject.getAttemptId() != null) {
                jsonGenerator.writeFieldName("attemptId").writeValue(taskObject.getAttemptId());
            }
            if ((objectsMap = taskObject.getObjects()) != null) {
                jsonGenerator.writeFieldName("objects");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, PipelineObject> objectsMapValue : objectsMap.entrySet()) {
                    if (objectsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(objectsMapValue.getKey());
                    PipelineObjectJsonMarshaller.getInstance().marshall(objectsMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskObjectJsonMarshaller();
        }
        return instance;
    }
}

