/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeConfigRulesRequestMarshaller
implements Marshaller<Request<DescribeConfigRulesRequest>, DescribeConfigRulesRequest> {
    @Override
    public Request<DescribeConfigRulesRequest> marshall(DescribeConfigRulesRequest describeConfigRulesRequest) {
        if (describeConfigRulesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeConfigRulesRequest> request = new DefaultRequest<DescribeConfigRulesRequest>(describeConfigRulesRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeConfigRules");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            SdkInternalList configRuleNamesList = (SdkInternalList)describeConfigRulesRequest.getConfigRuleNames();
            if (!configRuleNamesList.isEmpty() || !configRuleNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigRuleNames");
                jsonGenerator.writeStartArray();
                for (String configRuleNamesListValue : configRuleNamesList) {
                    if (configRuleNamesListValue == null) continue;
                    jsonGenerator.writeValue(configRuleNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeConfigRulesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeConfigRulesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

