/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DeliverConfigSnapshotRequestMarshaller
implements Marshaller<Request<DeliverConfigSnapshotRequest>, DeliverConfigSnapshotRequest> {
    @Override
    public Request<DeliverConfigSnapshotRequest> marshall(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        if (deliverConfigSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeliverConfigSnapshotRequest> request = new DefaultRequest<DeliverConfigSnapshotRequest>(deliverConfigSnapshotRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DeliverConfigSnapshot");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (deliverConfigSnapshotRequest.getDeliveryChannelName() != null) {
                jsonGenerator.writeFieldName("deliveryChannelName").writeValue(deliverConfigSnapshotRequest.getDeliveryChannelName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

