/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    @Override
    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRecordsRequest> request = new DefaultRequest<ListRecordsRequest>(listRecordsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() != null ? StringUtils.fromString(listRecordsRequest.getIdentityPoolId()) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listRecordsRequest.getIdentityId() != null ? StringUtils.fromString(listRecordsRequest.getIdentityId()) : "");
        uriResourcePath = uriResourcePath.replace("{DatasetName}", listRecordsRequest.getDatasetName() != null ? StringUtils.fromString(listRecordsRequest.getDatasetName()) : "");
        request.setResourcePath(uriResourcePath);
        if (listRecordsRequest.getLastSyncCount() != null) {
            request.addParameter("lastSyncCount", StringUtils.fromLong(listRecordsRequest.getLastSyncCount()));
        }
        if (listRecordsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString(listRecordsRequest.getNextToken()));
        }
        if (listRecordsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger(listRecordsRequest.getMaxResults()));
        }
        if (listRecordsRequest.getSyncSessionToken() != null) {
            request.addParameter("syncSessionToken", StringUtils.fromString(listRecordsRequest.getSyncSessionToken()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

