/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.LambdaConfigType;
import com.amazonaws.services.cognitoidp.model.UserPoolMfaType;
import com.amazonaws.services.cognitoidp.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidp.model.VerifiedAttributeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateUserPoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userPoolId;
    private UserPoolPolicyType policies;
    private LambdaConfigType lambdaConfig;
    private List<String> autoVerifiedAttributes;
    private String smsVerificationMessage;
    private String emailVerificationMessage;
    private String emailVerificationSubject;
    private String smsAuthenticationMessage;
    private String mfaConfiguration;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public UpdateUserPoolRequest withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
    }

    public UserPoolPolicyType getPolicies() {
        return this.policies;
    }

    public UpdateUserPoolRequest withPolicies(UserPoolPolicyType policies) {
        this.setPolicies(policies);
        return this;
    }

    public void setLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
    }

    public LambdaConfigType getLambdaConfig() {
        return this.lambdaConfig;
    }

    public UpdateUserPoolRequest withLambdaConfig(LambdaConfigType lambdaConfig) {
        this.setLambdaConfig(lambdaConfig);
        return this;
    }

    public List<String> getAutoVerifiedAttributes() {
        return this.autoVerifiedAttributes;
    }

    public void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
            return;
        }
        this.autoVerifiedAttributes = new ArrayList<String>(autoVerifiedAttributes);
    }

    public UpdateUserPoolRequest withAutoVerifiedAttributes(String ... autoVerifiedAttributes) {
        if (this.autoVerifiedAttributes == null) {
            this.setAutoVerifiedAttributes(new ArrayList<String>(autoVerifiedAttributes.length));
        }
        for (String ele : autoVerifiedAttributes) {
            this.autoVerifiedAttributes.add(ele);
        }
        return this;
    }

    public UpdateUserPoolRequest withAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        this.setAutoVerifiedAttributes(autoVerifiedAttributes);
        return this;
    }

    public UpdateUserPoolRequest withAutoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
        ArrayList<String> autoVerifiedAttributesCopy = new ArrayList<String>(autoVerifiedAttributes.length);
        for (VerifiedAttributeType value : autoVerifiedAttributes) {
            autoVerifiedAttributesCopy.add(value.toString());
        }
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(autoVerifiedAttributesCopy);
        } else {
            this.getAutoVerifiedAttributes().addAll(autoVerifiedAttributesCopy);
        }
        return this;
    }

    public void setSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
    }

    public String getSmsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public UpdateUserPoolRequest withSmsVerificationMessage(String smsVerificationMessage) {
        this.setSmsVerificationMessage(smsVerificationMessage);
        return this;
    }

    public void setEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
    }

    public String getEmailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public UpdateUserPoolRequest withEmailVerificationMessage(String emailVerificationMessage) {
        this.setEmailVerificationMessage(emailVerificationMessage);
        return this;
    }

    public void setEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
    }

    public String getEmailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public UpdateUserPoolRequest withEmailVerificationSubject(String emailVerificationSubject) {
        this.setEmailVerificationSubject(emailVerificationSubject);
        return this;
    }

    public void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
    }

    public String getSmsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public UpdateUserPoolRequest withSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.setSmsAuthenticationMessage(smsAuthenticationMessage);
        return this;
    }

    public void setMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
    }

    public String getMfaConfiguration() {
        return this.mfaConfiguration;
    }

    public UpdateUserPoolRequest withMfaConfiguration(String mfaConfiguration) {
        this.setMfaConfiguration(mfaConfiguration);
        return this;
    }

    public void setMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
    }

    public UpdateUserPoolRequest withMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.setMfaConfiguration(mfaConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: " + this.getPolicies() + ",");
        }
        if (this.getLambdaConfig() != null) {
            sb.append("LambdaConfig: " + this.getLambdaConfig() + ",");
        }
        if (this.getAutoVerifiedAttributes() != null) {
            sb.append("AutoVerifiedAttributes: " + this.getAutoVerifiedAttributes() + ",");
        }
        if (this.getSmsVerificationMessage() != null) {
            sb.append("SmsVerificationMessage: " + this.getSmsVerificationMessage() + ",");
        }
        if (this.getEmailVerificationMessage() != null) {
            sb.append("EmailVerificationMessage: " + this.getEmailVerificationMessage() + ",");
        }
        if (this.getEmailVerificationSubject() != null) {
            sb.append("EmailVerificationSubject: " + this.getEmailVerificationSubject() + ",");
        }
        if (this.getSmsAuthenticationMessage() != null) {
            sb.append("SmsAuthenticationMessage: " + this.getSmsAuthenticationMessage() + ",");
        }
        if (this.getMfaConfiguration() != null) {
            sb.append("MfaConfiguration: " + this.getMfaConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolRequest)) {
            return false;
        }
        UpdateUserPoolRequest other = (UpdateUserPoolRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getLambdaConfig() == null ^ this.getLambdaConfig() == null) {
            return false;
        }
        if (other.getLambdaConfig() != null && !other.getLambdaConfig().equals(this.getLambdaConfig())) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() == null ^ this.getAutoVerifiedAttributes() == null) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() != null && !other.getAutoVerifiedAttributes().equals(this.getAutoVerifiedAttributes())) {
            return false;
        }
        if (other.getSmsVerificationMessage() == null ^ this.getSmsVerificationMessage() == null) {
            return false;
        }
        if (other.getSmsVerificationMessage() != null && !other.getSmsVerificationMessage().equals(this.getSmsVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationMessage() == null ^ this.getEmailVerificationMessage() == null) {
            return false;
        }
        if (other.getEmailVerificationMessage() != null && !other.getEmailVerificationMessage().equals(this.getEmailVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationSubject() == null ^ this.getEmailVerificationSubject() == null) {
            return false;
        }
        if (other.getEmailVerificationSubject() != null && !other.getEmailVerificationSubject().equals(this.getEmailVerificationSubject())) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() == null ^ this.getSmsAuthenticationMessage() == null) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() != null && !other.getSmsAuthenticationMessage().equals(this.getSmsAuthenticationMessage())) {
            return false;
        }
        if (other.getMfaConfiguration() == null ^ this.getMfaConfiguration() == null) {
            return false;
        }
        return other.getMfaConfiguration() == null || other.getMfaConfiguration().equals(this.getMfaConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaConfig() == null ? 0 : this.getLambdaConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAutoVerifiedAttributes() == null ? 0 : this.getAutoVerifiedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSmsVerificationMessage() == null ? 0 : this.getSmsVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationMessage() == null ? 0 : this.getEmailVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationSubject() == null ? 0 : this.getEmailVerificationSubject().hashCode());
        hashCode = 31 * hashCode + (this.getSmsAuthenticationMessage() == null ? 0 : this.getSmsAuthenticationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMfaConfiguration() == null ? 0 : this.getMfaConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public UpdateUserPoolRequest clone() {
        return (UpdateUserPoolRequest)super.clone();
    }
}

