/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.ActionState;
import com.amazonaws.services.codepipeline.model.transform.ActionExecutionJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionRevisionJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ActionStateJsonMarshaller {
    private static ActionStateJsonMarshaller instance;

    public void marshall(ActionState actionState, StructuredJsonGenerator jsonGenerator) {
        if (actionState == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (actionState.getActionName() != null) {
                jsonGenerator.writeFieldName("actionName").writeValue(actionState.getActionName());
            }
            if (actionState.getCurrentRevision() != null) {
                jsonGenerator.writeFieldName("currentRevision");
                ActionRevisionJsonMarshaller.getInstance().marshall(actionState.getCurrentRevision(), jsonGenerator);
            }
            if (actionState.getLatestExecution() != null) {
                jsonGenerator.writeFieldName("latestExecution");
                ActionExecutionJsonMarshaller.getInstance().marshall(actionState.getLatestExecution(), jsonGenerator);
            }
            if (actionState.getEntityUrl() != null) {
                jsonGenerator.writeFieldName("entityUrl").writeValue(actionState.getEntityUrl());
            }
            if (actionState.getRevisionUrl() != null) {
                jsonGenerator.writeFieldName("revisionUrl").writeValue(actionState.getRevisionUrl());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionStateJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionStateJsonMarshaller();
        }
        return instance;
    }
}

